package com.ejie.ab78.util;

import java.util.Map;

public abstract class Node {

	public static final String NODE_TYPE_SIMPLE = "S";

	public static final String NODE_TYPE_COMPLEX = "C";

	private Node parent;

	private String keyGroup;

	public abstract void print();

	protected abstract String print(int deep);

	public abstract Map<String, String> map(Map<String, String> map);

	public abstract Map<String, String> map(Map<String, String> map, int deep, int limit);

	abstract Node find(String search);

	abstract Node find(String search, boolean wildcard);

	public Node getParent() {
		return parent;
	}

	abstract String getNodeType();

	public void setParent(Node parent) {
		this.parent = parent;
	}

	public String getKeyGroup() {
		if (keyGroup == null && parent != null) {
			return parent.getKeyGroup();
		}
		return keyGroup;
	}

	protected void setKeyGroup(String keyGroup) {
		this.keyGroup = keyGroup;
	}

}
