package com.ejie.ab78.util;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;

/**
 * DBUtils
 * 
 *  
 * 
 */
public class DBUtils {
	private static final Logger log = LoggerFactory.getLogger(DBUtils.class.getName());

	/**
	 * DBUtils
	 */
	private DBUtils() {

	};

	/**
	 * 
	 * callPLSQL Metodo que realiza las llamadas a los PL/SQL de calculo de
	 * ayuda
	 * 
	 * @param jdbcTemplate
	 *            JdbcTemplate
	 * @param procedure
	 *            String
	 * @param sqlParameters
	 *            SqlParameter[]
	 * @param parameterSource
	 *            MapSqlParameterSource
	 * @return m
	 * @throws Exception
	 *             Exception
	 */

	public static Map<String, Object> callPLSQLCalculoAyuda(JdbcTemplate jdbcTemplate, String procedure,
			SqlParameter[] sqlParameters, MapSqlParameterSource parameterSource) throws Exception {

		SimpleJdbcCall jdbcCall = new SimpleJdbcCall(jdbcTemplate).withSchemaName("AB78").withProcedureName(procedure)
				.withoutProcedureColumnMetaDataAccess().declareParameters(sqlParameters);
		Map<String, Object> m = jdbcCall.execute(parameterSource);
		if (m.get("OUT_AVISO") == null) {
			throw new Exception("Error en el proceso del PL/SQL de carga");

		} else {
			return m;
		}
	}

	/**
	 * 
	 * callPLSQL Metodo que realiza las llamadas a los PL/SQL de reparto de
	 * ayuda
	 * 
	 * @param jdbcTemplate
	 *            JdbcTemplate
	 * @param procedure
	 *            String
	 * @param sqlParameters
	 *            SqlParameter[]
	 * @param parameterSource
	 *            MapSqlParameterSource
	 * @return m
	 * @throws Exception
	 *             Exception
	 */

	public static Map<String, Object> callPLSQLRepartoAyuda(JdbcTemplate jdbcTemplate, String procedure,
			SqlParameter[] sqlParameters, MapSqlParameterSource parameterSource) throws Exception {

		SimpleJdbcCall jdbcCall = new SimpleJdbcCall(jdbcTemplate).withSchemaName("AB78").withProcedureName(procedure)
				.withoutProcedureColumnMetaDataAccess().declareParameters(sqlParameters);
		try {
			Map<String, Object> m = jdbcCall.execute(parameterSource);
			return m;
		} catch (Exception e) {
			log.error("Error en la llamada al PLSQL de reparto" + "-" + e.getMessage());
			throw new Exception("Error en el proceso del PL/SQL de reparto");
		}
	}

	/**
	 * 
	 * callPLSQL Metodo que realiza las llamadas a los PL/SQL
	 * 
	 * @param jdbcTemplate
	 *            JdbcTemplate
	 * @param procedure
	 *            String
	 * @param sqlParameters
	 *            SqlParameter[]
	 * @param parameterSource
	 *            MapSqlParameterSource
	 * @return m
	 * @throws Exception
	 *             Exception
	 */

	public static Map<String, Object> callPLSQL(JdbcTemplate jdbcTemplate, String procedure,
			SqlParameter[] sqlParameters, MapSqlParameterSource parameterSource) throws Exception {

		SimpleJdbcCall jdbcCall = new SimpleJdbcCall(jdbcTemplate).withProcedureName(procedure)
				.withoutProcedureColumnMetaDataAccess().declareParameters(sqlParameters);
		Map<String, Object> m = jdbcCall.execute(parameterSource);
		if (m.get("OUT_TITULO") == null) {
			throw new Exception("Error en el proceso del PL/SQL de carga");

		} else {
			return m;
		}
	}

	public static final Long lCERO = 0L;
	public static final int iCERO = 0;
	public static final int MAX_LONG_STRING_BUFFER = 3000;
}
