package com.ejie.ab78.util;

import java.io.StringWriter;

import javax.xml.soap.SOAPBody;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

/**
 * Common functions, use as impor static
 * 
 *  
 *
 */
public abstract class CommonObjectUtils {

	/**
	 * Check if obj is not null
	 * 
	 * @param obj
	 * @return
	 */
	public static boolean isNotNull(Object obj) {
		return !CommonObjectUtils.isNull(obj);
	}

	/**
	 * Check if obj is nulls
	 * 
	 * @param obj
	 * @return
	 */
	public static boolean isNull(Object obj) {
		return obj == null;
	}

	/**
	 * 
	 * @param value
	 * @param limit
	 * @return
	 */
	public static boolean isGreatherThan(Number value, Number limit) {
		return value.doubleValue() > limit.doubleValue();
	}

	/**
	 * 
	 * @param value
	 * @param limit
	 * @return
	 */
	public static boolean isLowerThan(Number value, Number limit) {
		return value.doubleValue() < limit.doubleValue();
	}

	/**
	 * 
	 * @param value
	 * @param limit
	 * @return
	 */
	public static boolean isEqualsOrGreatherThan(Number value, Number limit) {
		return value.doubleValue() >= limit.doubleValue();
	}

	/**
	 * 
	 * @param value
	 * @param limit
	 * @return
	 */
	public static boolean isEqualsOrLowerThan(Number value, Number limit) {
		return value.doubleValue() <= limit.doubleValue();
	}

	/**
	 * 
	 * @param number
	 * @param number2
	 * @return
	 */
	public static boolean isEquals(Number number, Number number2) {
		return number.doubleValue() == number2.doubleValue();
	}

	/**
	 * 
	 * @param number
	 * @param number2
	 * @return
	 */
	public static boolean isNotEquals(Number number, Number number2) {
		return !isEquals(number, number2);
	}

	public static String convertToString(SOAPBody message) throws Exception {
		Document doc = message.extractContentAsDocument();
		StringWriter sw = new StringWriter();
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");
		transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		transformer.transform(new DOMSource(doc), new StreamResult(sw));
		return sw.toString();
	}

	public static Boolean isBlank(String text) {
		return isNotNull(text) && "".equals(text);
	}

	public static Boolean notIsBlank(String text) {
		return isNotNull(text) && !isBlank(text);
	}

	public static String sanetizeStringToPrint(String text) {
		if (notIsBlank(text)) {
			return text.replace("null", "");
		}
		return "";
	}

}
