package com.ejie.ab78.tramita.services;

import java.io.InputStream;
import java.util.List;

import org.w3c.dom.Document;

import com.ejie.ab78.exceptions.PifException;
import com.ejie.y31.vo.Y31AttachmentBean;

public interface PifService {
	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param file
	 *            Stream de datos para acceder al contenido a copiar en el
	 *            repositorio
	 * @param pathTo
	 *            Ruta l�gica donde alojar el fichero. Incluir� como carpeta
	 *            principal la aplicaci�n destino (/p28b/...)
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @param Ttl
	 *            N�mero de segundos que se desea mantener el fichero en el
	 *            repositorio. Como m�ximo se podr� fijar el n�mero de
	 *            segundos de 15 d�as naturales
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	Y31AttachmentBean putFile(Document sSessionToken, InputStream file, String pathTo, boolean preserveName, Long Ttl)
			throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica de donde se va a descargar el fichero.
	 *            Incluir� como carpeta principal la aplicaci�n destino
	 * @return InputStream
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	InputStream getFile(Document sSessionToken, String pathFrom) throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta l�gica donde se va a mover el fichero. Incluir� como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	Y31AttachmentBean moveFile(Document sSessionToken, String pathFrom, String pathTo, boolean preserveName)
			throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta l�gica donde se va a mover el fichero. Incluir� como
	 *            carpeta principal la aplicaci�n destino
	 * @param boolena
	 *            preserveName preserveName
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	Y31AttachmentBean copyFile(Document sSessionToken, String pathFrom, String pathTo, boolean preserveName)
			throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @return List<Y31AttachmentBean>
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	List<Y31AttachmentBean> listFile(Document sSessionToken, String pathFrom) throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	void deleteFile(Document sSessionToken, String pathFrom) throws PifException;

}
