/**
 * 
 */
package com.ejie.ab78.tramita.adapter;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilsXlnets;
import com.ejie.ab78.exceptions.PifException;
import com.ejie.ab78.tramita.services.PifService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 *  
 * 
 */
@Service(value = "PifAdapterServiceImpl")
public class PifAdapterServiceImpl implements PifAdapterService {

	private static final Logger logger = LoggerFactory.getLogger(PifAdapterServiceImpl.class);

	@Autowired
	public PifService pifService;

	/**
	 * Clase que adaptara los servicios de PIF a nuestro sistema
	 */
	private PifAdapterServiceImpl() {
		super();
	}

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws NumberFormatException
	 * @throws PifException
	 */
	public String putFile(InputStream file, String fileName, String codAplic)
			throws NumberFormatException, PifException {

		PifAdapterServiceImpl.logger.info("INICIO putFile");
		PifAdapterServiceImpl.logger.info("Parammetro de entrada InputStream = " + file);
		PifAdapterServiceImpl.logger.info("Parammetro de entrada fileName = " + fileName);
		PifAdapterServiceImpl.logger.info("Parammetro de entrada codAplic = " + codAplic);

		String pathTo = "/" + codAplic.toLowerCase() + "/" + fileName;

		PifAdapterServiceImpl.logger.info("Path del PIF = " + pathTo);

		Y31AttachmentBean y31AttachmentBeanResult = this.pifService.putFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(),
				file, pathTo, true, Long.valueOf(Constantes.PIF_TIEMPO_EXISTENCIA));

		PifAdapterServiceImpl.logger.info("Retorno del putFile = " + y31AttachmentBeanResult.getFilePath());
		PifAdapterServiceImpl.logger.info("FIN putFile");

		return y31AttachmentBeanResult.getFilePath();
	}

	/**
	 * Subir documento a PIF con una persistencia determinada
	 * 
	 * @param file
	 *            InputStream: Fichero que se va a subir al PIF
	 * @param fileName
	 *            String: Nombre del fichero
	 * @param seconds
	 *            Long
	 * 
	 * @return String
	 * 
	 * @throws NumberFormatException
	 *             NumberFormatException
	 * @throws PifException
	 *             PifException
	 */
	public String putFileSeconds(InputStream file, String fileName, Long seconds)
			throws NumberFormatException, PifException {
		PifAdapterServiceImpl.logger.info("putFileSeconds - INICIO ");

		String pathTo = "/" + Constantes.CODIGO_APLICACION.toLowerCase() + "/" + fileName;
		Y31AttachmentBean y31AttachmentBeanResult = this.pifService
				.putFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), file, pathTo, true, seconds);
		return y31AttachmentBeanResult.getFilePath();
	}

	/**
	 * Obtener documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws NumberFormatException
	 * @throws PifException
	 */
	public BufferedInputStream getFile(String pathFrom) throws NumberFormatException, PifException {

		return (BufferedInputStream) this.pifService.getFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), pathFrom);

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param fileName
	 *            Nombre del fichero
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 */
	public Y31AttachmentBean moveFile(String pathFrom, String fileName, boolean preserveName) throws PifException {

		String pathTo = Constantes.CODIGO_APLICACION.toLowerCase() + "/" + fileName;
		return this.pifService.moveFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), pathFrom, pathTo, preserveName);

	}

	/**
	 * 
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta l�gica donde se va a mover el fichero. Incluir� como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 */
	public Y31AttachmentBean copyFile(String pathFrom, String pathTo, boolean preserveName) throws PifException {

		return this.pifService.copyFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), pathFrom, pathTo, preserveName);

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @return List<Y31AttachmentBean>
	 * @throws PifException
	 */
	public List<Y31AttachmentBean> listFile(String pathFrom) throws PifException {

		return this.pifService.listFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), pathFrom);

	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @throws PifException
	 */
	public void deleteFile(String pathFrom) throws PifException {

		this.pifService.deleteFile(UtilsXlnets.getInstance().getTokenAplicacionDocument(), pathFrom);
	}
}
