/**
 * 
 */
package com.ejie.ab78.tramita.adapter;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;

import com.ejie.ab78.exceptions.PifException;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 *  
 * 
 */
public interface PifAdapterService {

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws NumberFormatException
	 * @throws P28bPifException
	 */
	public String putFile(InputStream file, String fileName, String codAplic)
			throws NumberFormatException, PifException;

	/**
	 * Subir documento a PIF con una persistencia determinada
	 * 
	 * @param file
	 *            InputStream: Fichero que se va a subir al PIF
	 * @param fileName
	 *            String: Nombre del fichero
	 * @param seconds
	 *            Long
	 * 
	 * @return String
	 * 
	 * @throws NumberFormatException
	 *             NumberFormatException
	 * @throws PifException
	 *             PifException
	 */
	public String putFileSeconds(InputStream file, String fileName, Long seconds)
			throws NumberFormatException, PifException;

	/**
	 * Obtener documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws NumberFormatException
	 * @throws P28bPifException
	 */
	public BufferedInputStream getFile(String pathFrom) throws NumberFormatException, PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta l�gica donde se va a mover el fichero. Incluir� como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws P28bPifException
	 */
	public Y31AttachmentBean moveFile(String pathFrom, String pathTo, boolean preserveName) throws PifException;

	/**
	 * 
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta l�gica donde se va a mover el fichero. Incluir� como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de d�gitos que lo hace �nico en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws P28bPifException
	 */
	public Y31AttachmentBean copyFile(String pathFrom, String pathTo, boolean preserveName) throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @return List<Y31AttachmentBean>
	 * @throws P28bPifException
	 */
	public List<Y31AttachmentBean> listFile(String pathFrom) throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica desde donde se va a mover el fichero. Incluir�
	 *            como carpeta principal la aplicaci�n origen
	 * @throws P28bPifException
	 */
	public void deleteFile(String pathFrom) throws PifException;

}