package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.terceros.TiposTerceroDao;
import com.ejie.ab78.model.terceros.TiposTercero;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * TiposTerceroServiceImpl  
 * 
 *  
 */

@Service(value = "tiposTerceroService")
public class TiposTerceroServiceImpl implements TiposTerceroService {

	@Autowired
	private TiposTerceroDao tiposTerceroDao;

	@Transactional(rollbackFor = Throwable.class)
	public TiposTercero add(TiposTercero tiposTercero) {
		return this.tiposTerceroDao.add(tiposTercero);
	}

	@Transactional(rollbackFor = Throwable.class)
	public TiposTercero update(TiposTercero tiposTercero) {
		return this.tiposTerceroDao.update(tiposTercero);
	}

	public TiposTercero find(TiposTercero tiposTercero) {
		return this.tiposTerceroDao.find(tiposTercero);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void remove(TiposTercero tiposTercero) {
		this.tiposTerceroDao.remove(tiposTercero);
	}

	public List<TiposTercero> findAll(TiposTercero tiposTercero, TableRequestDto TableRequestDto) {
		return this.tiposTerceroDao.findAll(tiposTercero, TableRequestDto);
	}

	public List<TiposTercero> findAllLike(TiposTercero tiposTercero, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.tiposTerceroDao.findAllLike(tiposTercero, TableRequestDto, startsWith);
	}

	public TableResponseDto<TiposTercero> filter(TiposTercero filterTiposTercero, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<TiposTercero> listaTiposTercero = this.tiposTerceroDao.findAllLike(filterTiposTercero, TableRequestDto,
				false);
		Long recordNum = this.tiposTerceroDao
				.findAllLikeCount(filterTiposTercero != null ? filterTiposTercero : new TiposTercero(), false);
		
		return new TableResponseDto<TiposTercero>(TableRequestDto, recordNum, listaTiposTercero);
	}

	@Override
	public List<TiposTercero> getSubtiposAll(TiposTercero tiposTercero) {
		return this.tiposTerceroDao.getSubtiposAll(tiposTercero);
	}

}
