package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.terceros.TiposDocumentoDao;
import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDocumentoServiceImpl  
 * 
 *  
 */

@Service(value = "tiposDocumentoService")
public class TiposDocumentoServiceImpl implements TiposDocumentoService {

	@Autowired
	private TiposDocumentoDao tiposDocumentoDao;

	/**
	 * Inserts a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposDocumento add(TiposDocumento tiposDocumento) {
		return this.tiposDocumentoDao.add(tiposDocumento);
	}

	/**
	 * Updates a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposDocumento update(TiposDocumento tiposDocumento) {
		return this.tiposDocumentoDao.update(tiposDocumento);
	}

	/**
	 * Finds a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	public TiposDocumento find(TiposDocumento tiposDocumento) {
		return (TiposDocumento) this.tiposDocumentoDao.find(tiposDocumento);
	}

	/**
	 * Deletes a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TiposDocumento tiposDocumento) {
		this.tiposDocumentoDao.remove(tiposDocumento);
	}

	/**
	 * Finds a list of rows in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDocumento>
	 */
	public List<TiposDocumento> findAll(TiposDocumento tiposDocumento, TableRequestDto TableRequestDto) {
		return (List<TiposDocumento>) this.tiposDocumentoDao.findAll(tiposDocumento, TableRequestDto);
	}

	/**
	 * Finds rows in the TiposDocumento table using like.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDocumento>
	 */
	public List<TiposDocumento> findAllLike(TiposDocumento tiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return (List<TiposDocumento>) this.tiposDocumentoDao.findAllLike(tiposDocumento, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		this.tiposDocumentoDao.removeMultiple(filterTiposDocumento, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposDocumento>
	 */
	public TableResponseDto<TiposDocumento> filter(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<TiposDocumento> listaTiposDocumento = this.tiposDocumentoDao.findAllLike(filterTiposDocumento,
				TableRequestDto, false);
		Long recordNum = this.tiposDocumentoDao
				.findAllLikeCount(filterTiposDocumento != null ? filterTiposDocumento : new TiposDocumento(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TiposDocumento>> reorderSelection = this.tiposDocumentoDao
					.reorderSelection(filterTiposDocumento, TableRequestDto, startsWith);
			return new TableResponseDto<TiposDocumento>(TableRequestDto, recordNum, listaTiposDocumento,
					reorderSelection);
		}
		return new TableResponseDto<TiposDocumento>(TableRequestDto, recordNum, listaTiposDocumento);
	}

	/**
	 * Searches rows in the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param searchTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	public List<TableRowDto<TiposDocumento>> search(TiposDocumento filterTiposDocumento,
			TiposDocumento searchTiposDocumento, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.tiposDocumentoDao.search(filterTiposDocumento, searchTiposDocumento, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.tiposDocumentoDao.reorderSelection(filterTiposDocumento, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>>
	 */
	public TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquia(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<TiposDocumento>> listaTiposDocumento = this.tiposDocumentoDao
				.findAllLikeJerarquia(filterTiposDocumento, TableRequestDto);
		Long recordNum = this.tiposDocumentoDao.findAllLikeCountJerarquia(filterTiposDocumento, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<TiposDocumento>>(TableRequestDto, recordNum, listaTiposDocumento);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the TiposDocumento
	 * table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>>
	 */
	public TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquiaChildren(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<TiposDocumento>> TableResponseDto = new TableResponseDto<JerarquiaDto<TiposDocumento>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.tiposDocumentoDao.findAllChild(filterTiposDocumento, TableRequestDto));
		return TableResponseDto;
	}

}
