package com.ejie.ab78.service.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDocumentoService  
 * 
 *  
 */

public interface TiposDocumentoService {

	/**
	 * Inserts a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento add(TiposDocumento tiposDocumento);

	/**
	 * Updates a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento update(TiposDocumento tiposDocumento);

	/**
	 * Finds a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento find(TiposDocumento tiposDocumento);

	/**
	 * Deletes a single row in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 */
	void remove(TiposDocumento tiposDocumento);

	/**
	 * Finds a list of rows in the TiposDocumento table.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDocumento>
	 */
	List<TiposDocumento> findAll(TiposDocumento tiposDocumento, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposDocumento table using like.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDocumento>
	 */
	List<TiposDocumento> findAllLike(TiposDocumento tiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposDocumento>
	 */
	TableResponseDto<TiposDocumento> filter(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param searchTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	List<TableRowDto<TiposDocumento>> search(TiposDocumento filterTiposDocumento, TiposDocumento searchTiposDocumento,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>>
	 */
	TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquia(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the TiposDocumento
	 * table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>>
	 */
	TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquiaChildren(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto);

}
