package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.terceros.TiposDireccionDao;
import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDireccionServiceImpl  
 * 
 *  
 */

@Service(value = "tiposDireccionService")
public class TiposDireccionServiceImpl implements TiposDireccionService {

	@Autowired
	private TiposDireccionDao tiposDireccionDao;

	/**
	 * Inserts a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposDireccion add(TiposDireccion tiposDireccion) {
		return this.tiposDireccionDao.add(tiposDireccion);
	}

	/**
	 * Updates a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposDireccion update(TiposDireccion tiposDireccion) {
		return this.tiposDireccionDao.update(tiposDireccion);
	}

	/**
	 * Finds a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	public TiposDireccion find(TiposDireccion tiposDireccion) {
		return (TiposDireccion) this.tiposDireccionDao.find(tiposDireccion);
	}

	/**
	 * Deletes a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TiposDireccion tiposDireccion) {
		this.tiposDireccionDao.remove(tiposDireccion);
	}

	/**
	 * Finds a list of rows in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDireccion>
	 */
	public List<TiposDireccion> findAll(TiposDireccion tiposDireccion, TableRequestDto TableRequestDto) {
		return (List<TiposDireccion>) this.tiposDireccionDao.findAll(tiposDireccion, TableRequestDto);
	}

	/**
	 * Finds rows in the TiposDireccion table using like.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDireccion>
	 */
	public List<TiposDireccion> findAllLike(TiposDireccion tiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return (List<TiposDireccion>) this.tiposDireccionDao.findAllLike(tiposDireccion, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		this.tiposDireccionDao.removeMultiple(filterTiposDireccion, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposDireccion>
	 */
	public TableResponseDto<TiposDireccion> filter(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<TiposDireccion> listaTiposDireccion = this.tiposDireccionDao.findAllLike(filterTiposDireccion,
				TableRequestDto, false);
		Long recordNum = this.tiposDireccionDao
				.findAllLikeCount(filterTiposDireccion != null ? filterTiposDireccion : new TiposDireccion(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TiposDireccion>> reorderSelection = this.tiposDireccionDao
					.reorderSelection(filterTiposDireccion, TableRequestDto, startsWith);
			return new TableResponseDto<TiposDireccion>(TableRequestDto, recordNum, listaTiposDireccion,
					reorderSelection);
		}
		return new TableResponseDto<TiposDireccion>(TableRequestDto, recordNum, listaTiposDireccion);
	}

	/**
	 * Searches rows in the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param searchTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	public List<TableRowDto<TiposDireccion>> search(TiposDireccion filterTiposDireccion,
			TiposDireccion searchTiposDireccion, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.tiposDireccionDao.search(filterTiposDireccion, searchTiposDireccion, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.tiposDireccionDao.reorderSelection(filterTiposDireccion, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>>
	 */
	public TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquia(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<TiposDireccion>> listaTiposDireccion = this.tiposDireccionDao
				.findAllLikeJerarquia(filterTiposDireccion, TableRequestDto);
		Long recordNum = this.tiposDireccionDao.findAllLikeCountJerarquia(filterTiposDireccion, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<TiposDireccion>>(TableRequestDto, recordNum, listaTiposDireccion);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the TiposDireccion
	 * table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>>
	 */
	public TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquiaChildren(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<TiposDireccion>> TableResponseDto = new TableResponseDto<JerarquiaDto<TiposDireccion>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.tiposDireccionDao.findAllChild(filterTiposDireccion, TableRequestDto));
		return TableResponseDto;
	}

}
