package com.ejie.ab78.service.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDireccionService  
 * 
 *  
 */

public interface TiposDireccionService {

	/**
	 * Inserts a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion add(TiposDireccion tiposDireccion);

	/**
	 * Updates a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion update(TiposDireccion tiposDireccion);

	/**
	 * Finds a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion find(TiposDireccion tiposDireccion);

	/**
	 * Deletes a single row in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 */
	void remove(TiposDireccion tiposDireccion);

	/**
	 * Finds a list of rows in the TiposDireccion table.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDireccion>
	 */
	List<TiposDireccion> findAll(TiposDireccion tiposDireccion, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposDireccion table using like.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDireccion>
	 */
	List<TiposDireccion> findAllLike(TiposDireccion tiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposDireccion>
	 */
	TableResponseDto<TiposDireccion> filter(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param searchTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	List<TableRowDto<TiposDireccion>> search(TiposDireccion filterTiposDireccion, TiposDireccion searchTiposDireccion,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>>
	 */
	TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquia(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the TiposDireccion
	 * table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>>
	 */
	TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquiaChildren(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto);

}
