package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.dao.terceros.RelDenunciaTerceroDao;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.RelDenunciaTercero;
import com.ejie.ab78.model.terceros.RelExpTer;
import com.ejie.ab78.model.terceros.TiposTercero;
import com.ejie.ab78.service.denuncias.DenunciasService;
import com.ejie.ab78.service.expedientes.ExpedientesService;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

@Service(value = "relDenunciaTerceroService")
public class RelDenunciaTerceroServiceImpl implements RelDenunciaTerceroService {

	@Autowired
	private RelDenunciaTerceroDao relDenunciaTerceroDao;

	@Autowired
	private DenunciasService denunciasService;

	@Autowired
	private ExpedientesService expedientesService;

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	@Autowired
	private DatosTercerosService datosTercerosService;

	@Autowired
	private RelExpTerService relExpTerService;

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public RelDenunciaTercero add(RelDenunciaTercero relDenunciaTercero) {
		return this.relDenunciaTerceroDao.add(relDenunciaTercero);
	}

	@Override
	public RelDenunciaTercero update(RelDenunciaTercero relDenunciaTercero) {
		return this.relDenunciaTerceroDao.update(relDenunciaTercero);
	}

	@Override
	public RelDenunciaTercero updateById(RelDenunciaTercero relDenunciaTercero) {
		return this.relDenunciaTerceroDao.updateById(relDenunciaTercero);
	}

	@Override
	public RelDenunciaTercero find(RelDenunciaTercero relDenunciaTercero) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove(RelDenunciaTercero relDenunciaTercero) {
		this.relDenunciaTerceroDao.remove(relDenunciaTercero);

	}

	@Override
	public List<RelDenunciaTercero> findAll(RelDenunciaTercero relDenunciaTercero, TableRequestDto TableRequestDto) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<RelDenunciaTercero> findAllLike(RelDenunciaTercero relDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void removeMultiple(RelDenunciaTercero filterRelDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// TODO Auto-generated method stub

	}

	@Override
	public TableResponseDto<RelDenunciaTercero> filter(RelDenunciaTercero filterRelDenunciaTercero,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<TableRowDto<RelDenunciaTercero>> search(RelDenunciaTercero filterRelDenunciaTercero,
			RelDenunciaTercero searchRelDenunciaTercero, TableRequestDto TableRequestDto, Boolean startsWith) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object reorderSelection(RelDenunciaTercero filterRelDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TableResponseDto<JerarquiaDto<RelDenunciaTercero>> jerarquiaChildren(
			RelDenunciaTercero filterRelDenunciaTercero, TableRequestDto TableRequestDto) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<RelDenunciaTercero> getRelDenunciaTerceroByFolderId(Expedientes expediente) {
		return this.relDenunciaTerceroDao.getRelDenunciaTerceroByFolderId(expediente);
	}

	@Override
	public Integer getIdDenunciaByFolderId(Expedientes expediente) {
		return this.relDenunciaTerceroDao.getIdDenunciaByFolderId(expediente);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public RelDenunciaTercero guardarInfoContactoTercero(RelDenunciaTercero relDenunciaTercero, Boolean isExpediente) {

		if (null != relDenunciaTercero) {

			if (null != relDenunciaTercero.getDatosDirecciones().getIdDireccion()
					&& relDenunciaTercero.getDatosDirecciones().getIdDireccion() > 0
					&& null != relDenunciaTercero.getDatosDirecciones().getDatosTerceros()
					&& relDenunciaTercero.getDatosDirecciones().getDatosTerceros().getIdTercero() > 0) {

				this.datosDireccionesService.update(relDenunciaTercero.getDatosDirecciones());
				this.datosTercerosService.update(relDenunciaTercero.getDatosDirecciones().getDatosTerceros());

			} else {
				DatosTerceros datosTerceros = relDenunciaTercero.getDatosDirecciones().getDatosTerceros();
				datosTerceros = this.datosTercerosService.add(datosTerceros);

				this.datosDireccionesService.add(relDenunciaTercero.getDatosDirecciones());

				relDenunciaTercero.setDatosTerceros(datosTerceros);
				if (isExpediente) {
					Denuncia denuncia = this.denunciasService.find(new Denuncia(relDenunciaTercero.getIdReclamacion()));
					RelExpTer participacion = new RelExpTer();

					participacion.setIdExpediente(denuncia.getExpediente().getIdExpediente());
					participacion.setDatosTerceros(datosTerceros);
					participacion.setTiposTercero(new TiposTercero(relDenunciaTercero.getIdTipoTercero()));

					this.relExpTerService.add(participacion);
				} else {
					this.add(relDenunciaTercero);
				}
			}

		}
		return relDenunciaTercero;
	}

	@Override
	public RelDenunciaTercero getRelDenunciaTerceroIdExpediente(Integer idExpediente, Integer idTercero) {
		return this.relDenunciaTerceroDao.getRelDenunciaTerceroIdExpediente(idExpediente, idTercero);
	}

	@Override
	public RelDenunciaTercero getRelDenunciaIdTercero(Integer idTercero) {
		return this.relDenunciaTerceroDao.getRelDenunciaIdTercero(idTercero);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void borrarInfoContactoTercero(Integer idTercero, Integer idExpediente, Boolean isExpediente) {
		DatosDirecciones datosDirecciones = this.datosDireccionesService.findByIdTercero(idTercero,
				Constantes.ID_DIRECCION_NOTIF_POSTAL);

		if (null != datosDirecciones && null != datosDirecciones.getIdDireccion()) {
			this.datosDireccionesService.remove(datosDirecciones);
		}

		if (isExpediente) {
			RelExpTer relExpTer = this.relExpTerService.getRelExpTerByExpTercero(idExpediente, idTercero);

			if (null != relExpTer && null != relExpTer.getIdRelExpTer()) {
				this.relExpTerService.remove(relExpTer);
			}
		} else {
			RelDenunciaTercero relDenunciaTercero = this.getRelDenunciaIdTercero(idTercero);
			this.remove(relDenunciaTercero);
		}

		DatosTerceros datosTerceros = this.datosTercerosService.find(idTercero);
		if (null != datosTerceros && null != datosTerceros.getIdTercero()) {
			this.datosTercerosService.remove(idTercero);
		}

	}

	@Override
	public List<RelDenunciaTercero> getRelDenunciaTerceroByIdReclamacion(Denuncia denuncia) {
		return this.relDenunciaTerceroDao.getRelDenunciaTerceroByIdReclamacion(denuncia);
	}

	@Override
	public Integer findCIF(String documentoTercero) {
		return this.relDenunciaTerceroDao.getByCif(documentoTercero);
	}

}
