package com.ejie.ab78.service.terceros;

import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.RelDenunciaTercero;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

public interface RelDenunciaTerceroService {

	/**
	 * Inserts a single row in the RelDenunciaTercero table.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 * @return RelDenunciaTercero
	 */
	RelDenunciaTercero add(RelDenunciaTercero relDenunciaTercero);

	/**
	 * Updates a single row in the RelDenunciaTercero table.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 * @return RelDenunciaTercero
	 */
	RelDenunciaTercero update(RelDenunciaTercero relDenunciaTercero);

	/**
	 * Finds a single row in the RelDenunciaTercero table.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 * @return RelDenunciaTercero
	 */
	RelDenunciaTercero find(RelDenunciaTercero relDenunciaTercero);

	/**
	 * Deletes a single row in the RelDenunciaTercero table.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 */
	void remove(RelDenunciaTercero relDenunciaTercero);

	/**
	 * Finds a list of rows in the RelDenunciaTercero table.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<RelDenunciaTercero>
	 */
	List<RelDenunciaTercero> findAll(RelDenunciaTercero relDenunciaTercero, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the RelDenunciaTercero table using like.
	 *
	 * @param relDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelDenunciaTercero>
	 */
	List<RelDenunciaTercero> findAllLike(RelDenunciaTercero relDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelDenunciaTercero table.
	 *
	 * @param filterRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(RelDenunciaTercero filterRelDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Filter method in the RelDenunciaTercero table.
	 *
	 * @param filterRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelDenunciaTercero>
	 */
	TableResponseDto<RelDenunciaTercero> filter(RelDenunciaTercero filterRelDenunciaTercero,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the RelDenunciaTercero table.
	 *
	 * @param filterRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param searchRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelDenunciaTercero>>
	 */
	List<TableRowDto<RelDenunciaTercero>> search(RelDenunciaTercero filterRelDenunciaTercero,
			RelDenunciaTercero searchRelDenunciaTercero, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in RelDenunciaTercero table.
	 *
	 * @param filterRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(RelDenunciaTercero filterRelDenunciaTercero, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method for siblings rows in the hierarchical the
	 * RelDenunciaTercero table.
	 *
	 * @param filterRelDenunciaTercero
	 *            RelDenunciaTercero
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelDenunciaTercero>>
	 */
	TableResponseDto<JerarquiaDto<RelDenunciaTercero>> jerarquiaChildren(RelDenunciaTercero filterRelDenunciaTercero,
			TableRequestDto TableRequestDto);

	List<RelDenunciaTercero> getRelDenunciaTerceroByFolderId(Expedientes expediente);

	Integer getIdDenunciaByFolderId(Expedientes expediente);

	RelDenunciaTercero guardarInfoContactoTercero(RelDenunciaTercero relDenunciaTercero, Boolean isExpediente);

	RelDenunciaTercero getRelDenunciaTerceroIdExpediente(Integer idExpediente, Integer idTercero);

	void borrarInfoContactoTercero(Integer idTercero, Integer idExpediente, Boolean isExpediente);

	List<RelDenunciaTercero> getRelDenunciaTerceroByIdReclamacion(Denuncia denuncia);

	RelDenunciaTercero updateById(RelDenunciaTercero relDenunciaTercero);

	RelDenunciaTercero getRelDenunciaIdTercero(Integer idTercero);

	Integer findCIF(String documentoTercero);
}
