package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.terceros.DatosTercerosDao;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * DatosTercerosServiceImpl  
 * 
 *  
 */

@Service(value = "datosTercerosService")
public class DatosTercerosServiceImpl implements DatosTercerosService {

	@Autowired
	private DatosTercerosDao datosTercerosDao;

	@Transactional(rollbackFor = Throwable.class)
	public DatosTerceros add(DatosTerceros datosTerceros) {
		return this.datosTercerosDao.add(datosTerceros);
	}

	public DatosTerceros findUltimoId() {
		return this.datosTercerosDao.findUltimoId();
	}

	@Transactional(rollbackFor = Throwable.class)
	public DatosTerceros update(DatosTerceros datosTerceros) {
		return this.datosTercerosDao.update(datosTerceros);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void remove(Integer idTercero) {
		this.datosTercerosDao.remove(idTercero);
	}

	public List<DatosTerceros> findAll(DatosTerceros datosTerceros, TableRequestDto TableRequestDto) {
		return this.datosTercerosDao.findAll(datosTerceros, TableRequestDto);
	}

	public List<DatosTerceros> findAllLike(DatosTerceros datosTerceros, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.datosTercerosDao.findAllLike(datosTerceros, TableRequestDto, startsWith);
	}

	public TableResponseDto<DatosTerceros> filter(DatosTerceros filterDatosTerceros, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<DatosTerceros> listaDatosTerceros = this.datosTercerosDao.findAllLike(filterDatosTerceros, TableRequestDto,
				false);
		Long recordNum = this.datosTercerosDao
				.findAllLikeCount(filterDatosTerceros != null ? filterDatosTerceros : new DatosTerceros(), false);

		return new TableResponseDto<DatosTerceros>(TableRequestDto, recordNum, listaDatosTerceros);
	}

	public List<DatosTerceros> findAllByExpdiente(Expedientes datosTerceros) {
		return this.datosTercerosDao.findAllByExpdiente(datosTerceros);
	}

	@Override
	public DatosTerceros find(Integer idTercero) {
		return this.datosTercerosDao.findById(idTercero);
	}

	@Override
	public DatosTerceros addTerceroSearchFolder(DatosTerceros datosTerceros) {
		return datosTercerosDao.addTerceroSearchFolder(datosTerceros);
	}
}
