package com.ejie.ab78.service.terceros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.dao.expedientes.RelExpDirDao;
import com.ejie.ab78.dao.terceros.DatosDireccionesDao;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.RelExpDir;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DatosDireccionesServiceImpl  
 * 
 *  
 */

@Service(value = "datosDireccionesService")
public class DatosDireccionesServiceImpl implements DatosDireccionesService {

	@Autowired
	private DatosDireccionesDao datosDireccionesDao;

	@Autowired
	private RelExpDirDao relExpDirDao;

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public DatosDirecciones add(DatosDirecciones datosDirecciones) {
		return this.datosDireccionesDao.add(datosDirecciones);
	}

	/**
	 * Updates a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public DatosDirecciones update(DatosDirecciones datosDirecciones) {
		return this.datosDireccionesDao.update(datosDirecciones);
	}

	/**
	 * Finds a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	public DatosDirecciones find(Integer idDireccion) {
		return this.datosDireccionesDao.find(new DatosDirecciones(idDireccion));
	}

	/**
	 * Finds a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	@Override
	public DatosDirecciones find(DatosDirecciones datosDirecciones) {
		return this.datosDireccionesDao.find(datosDirecciones);
	}

	/**
	 * Deletes a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosDirecciones datosDirecciones) {
		this.datosDireccionesDao.remove(datosDirecciones);
	}

	/**
	 * Finds a list of rows in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<DatosDirecciones>
	 */
	@Override
	public List<DatosDirecciones> findAll(DatosDirecciones datosDirecciones, TableRequestDto TableRequestDto) {
		return this.datosDireccionesDao.findAll(datosDirecciones, TableRequestDto);
	}

	/**
	 * Finds rows in the DatosDirecciones table using like.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<DatosDirecciones>
	 */
	@Override
	public List<DatosDirecciones> findAllLike(DatosDirecciones datosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.datosDireccionesDao.findAllLike(datosDirecciones, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		this.datosDireccionesDao.removeMultiple(filterDatosDirecciones, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<DatosDirecciones>
	 */
	@Override
	public TableResponseDto<DatosDirecciones> filter(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<DatosDirecciones> listaDatosDirecciones = this.datosDireccionesDao.findAllLike(filterDatosDirecciones,
				TableRequestDto, false);
		Long recordNum = this.datosDireccionesDao.findAllLikeCount(
				filterDatosDirecciones != null ? filterDatosDirecciones : new DatosDirecciones(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<DatosDirecciones>> reorderSelection = this.datosDireccionesDao
					.reorderSelection(filterDatosDirecciones, TableRequestDto, startsWith);
			return new TableResponseDto<DatosDirecciones>(TableRequestDto, recordNum, listaDatosDirecciones,
					reorderSelection);
		}
		return new TableResponseDto<DatosDirecciones>(TableRequestDto, recordNum, listaDatosDirecciones);
	}

	/**
	 * Searches rows in the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param searchDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	@Override
	public List<TableRowDto<DatosDirecciones>> search(DatosDirecciones filterDatosDirecciones,
			DatosDirecciones searchDatosDirecciones, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.datosDireccionesDao.search(filterDatosDirecciones, searchDatosDirecciones, TableRequestDto,
				startsWith);
	}

	/**
	 * Reorder the selection made in DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	@Override
	public Object reorderSelection(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.datosDireccionesDao.reorderSelection(filterDatosDirecciones, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>>
	 */
	@Override
	public TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquia(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<DatosDirecciones>> listaDatosDirecciones = this.datosDireccionesDao
				.findAllLikeJerarquia(filterDatosDirecciones, TableRequestDto);
		Long recordNum = this.datosDireccionesDao.findAllLikeCountJerarquia(filterDatosDirecciones, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<DatosDirecciones>>(TableRequestDto, recordNum, listaDatosDirecciones);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the DatosDirecciones
	 * table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>>
	 */
	@Override
	public TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquiaChildren(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<DatosDirecciones>> TableResponseDto = new TableResponseDto<JerarquiaDto<DatosDirecciones>>();
		TableResponseDto.addAdditionalParam(com.ejie.x38.dto.TableResponseDto.CHILDREN,
				this.datosDireccionesDao.findAllChild(filterDatosDirecciones, TableRequestDto));
		return TableResponseDto;
	}

	@Override
	public DatosDirecciones findEstablecimientoExpediente(Integer idExpediente) {
		return this.datosDireccionesDao.findEstablecimientoExpediente(idExpediente);
	}

	@Override
	public DatosDirecciones findEstablecimientoRelacionadoExpediente(Integer idExpediente) {
		return this.datosDireccionesDao.findEstablecimientoRelacionadoExpediente(idExpediente);
	}

	@Override
	public DatosDirecciones findPostalTerceroId(Integer idExpediente) {
		return this.datosDireccionesDao.findPostalTerceroId(idExpediente);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public DatosDirecciones crearDireccionFromExpedienteOrigen(Integer idExpediente, Integer idExpedienteOrigen,
			Integer idTerceroTitular) {
		DatosDirecciones datosDireccionesOrigen = this.findEstablecimientoExpediente(idExpedienteOrigen);
		datosDireccionesOrigen.setIdDireccion(null);
		datosDireccionesOrigen.setDatosTerceros(new DatosTerceros(idTerceroTitular));
		this.add(datosDireccionesOrigen);
		return this.findEstablecimientoExpediente(idExpediente);
	}

	@Override
	public DatosDirecciones findByIdTercero(Integer idTitular, long idDireccionActividad) {
		return this.datosDireccionesDao.findByIdTercero(idTitular, idDireccionActividad);
	}

	@Override
	public List<DatosDirecciones> findInfoContactoTercero(Integer idTercero) {
		return this.datosDireccionesDao.findInfoContactoTercero(idTercero);
	}

	@Override
	public int updateDireccionEstablecimientoDenunciado(DatosDirecciones datosdirecciones) {
		return this.datosDireccionesDao.updateDireccionEstablecimientoDenunciado(datosdirecciones);
	}

	@Override
	public void addDireccionDenuncia(Denuncia denuncia) {
		DatosDirecciones datosDirecciones = denuncia.getDireccionDenunciado();
		datosDirecciones.setTiposDireccion(new TiposDireccion(Constantes.ID_DIRECCION_ACTIVIDAD));
		datosDirecciones = this.datosDireccionesDao.addDireccionDenuncia(datosDirecciones);
		RelExpDir relExpDir = new RelExpDir();
		relExpDir.setExpediente(denuncia.getExpediente());
		relExpDir.setDatosDireccion(datosDirecciones);
		this.relExpDirDao.add(relExpDir);
	}
	
	@Override
	public DatosDirecciones buscarEstablecimiento(String numeroRegistro) {
		return this.datosDireccionesDao.buscarEstablecimiento(numeroRegistro);
	}

}
