package com.ejie.ab78.service.terceros;

import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DatosDireccionesService  
 * 
 *  
 */

public interface DatosDireccionesService {

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones add(DatosDirecciones datosDirecciones);

	/**
	 * Updates a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones update(DatosDirecciones datosDirecciones);

	/**
	 * Finds a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones find(DatosDirecciones datosDirecciones);

	/**
	 * Finds a single row in the DatosDirecciones table.
	 *
	 * @param Integer
	 *            idDireccion
	 * @return DatosDirecciones
	 */
	DatosDirecciones find(Integer idDireccion);

	/**
	 * Deletes a single row in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 */
	void remove(DatosDirecciones datosDirecciones);

	/**
	 * Finds a list of rows in the DatosDirecciones table.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<DatosDirecciones>
	 */
	List<DatosDirecciones> findAll(DatosDirecciones datosDirecciones, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the DatosDirecciones table using like.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<DatosDirecciones>
	 */
	List<DatosDirecciones> findAllLike(DatosDirecciones datosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<DatosDirecciones>
	 */
	TableResponseDto<DatosDirecciones> filter(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param searchDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	List<TableRowDto<DatosDirecciones>> search(DatosDirecciones filterDatosDirecciones,
			DatosDirecciones searchDatosDirecciones, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>>
	 */
	TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquia(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the DatosDirecciones
	 * table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>>
	 */
	TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquiaChildren(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto);

	DatosDirecciones findEstablecimientoExpediente(Integer idExpediente);

	DatosDirecciones findEstablecimientoRelacionadoExpediente(Integer idExpediente);

	DatosDirecciones findPostalTerceroId(Integer idExpediente);

	DatosDirecciones crearDireccionFromExpedienteOrigen(Integer idExpediente, Integer idExpedienteOrigen,
			Integer idTerceroTitular);

	DatosDirecciones findByIdTercero(Integer idTitular, long idDireccionActividad);

	List<DatosDirecciones> findInfoContactoTercero(Integer idTercero);

	int updateDireccionEstablecimientoDenunciado(DatosDirecciones datosdirecciones);

	void addDireccionDenuncia(Denuncia denuncia);
	
	DatosDirecciones buscarEstablecimiento(String numeroRegistro);

}
