package com.ejie.ab78.service.terceros;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.terceros.CanalesAvisoDao;
import com.ejie.ab78.model.terceros.CanalesAviso;

/**
 * CanalesAvisoServiceImpl  
 * 
 *  
 */

@Service(value = "canalesAvisoService")
public class CanalesAvisoServiceImpl implements CanalesAvisoService {

	@Autowired
	private CanalesAvisoDao canalesAvisoDao;

	/**
	 * Inserts a single row in the CanalesAviso table.
	 *
	 * @param canalesAviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CanalesAviso add(CanalesAviso canalesAviso) {
		return this.canalesAvisoDao.add(canalesAviso);
	}

	/**
	 * Updates a single row in the CanalesAviso table.
	 *
	 * @param canalesAviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CanalesAviso update(CanalesAviso canalesAviso) {
		return this.canalesAvisoDao.update(canalesAviso);
	}

	/**
	 * Finds a single row in the CanalesAviso table.
	 *
	 * @param canalesAviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	public CanalesAviso find(CanalesAviso canalesAviso) {
		return (CanalesAviso) this.canalesAvisoDao.find(canalesAviso);
	}

	/**
	 * Deletes a single row in the CanalesAviso table.
	 *
	 * @param canalesAviso
	 *            CanalesAviso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CanalesAviso canalesAviso) {
		this.canalesAvisoDao.remove(canalesAviso);
	}

}
