package com.ejie.ab78.service.procedimientos;

import java.util.List;
import java.util.Map;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosDirecciones;

public interface ProcedureActions {

	/**
	 * Comprobacion de si se puede guadar el expediente
	 * 
	 * @param form
	 * @return
	 */
	Boolean isEnableSaveExpediente(Expedientes form);

	/**
	 * Comprobacion de si se puede ejecutar la accion del procedimiento
	 * 
	 * @param form
	 * @return
	 */
	Boolean isEnableExecuteAction(Expedientes form);

	Boolean isInspectionable(Expedientes form);

	Boolean isEnableInspect(Expedientes form);

	Boolean isEnableAccessCenso(Expedientes form);

	Boolean isEnableAccessInspecciones(Expedientes form);

	Boolean isEnableCreateDocs(Expedientes form);

	Boolean isEnableShowUbicacionEstablecimiento(Expedientes form);

	Boolean hasSecondButton(Expedientes form);

	String getButtonsText(Expedientes form);

	Map<String, String> executeAction(Expedientes form, Denuncia denuncia);

	List<String> getPestanaConfig();

	DatosDirecciones findDireccioneDenunciado(Expedientes form);

	Denuncia findDenuncia(Expedientes form);

	Boolean isCloseExpediente(Expedientes form);

}
