package com.ejie.ab78.service.procedimientos;

import java.util.HashMap;
import java.util.Map;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.service.expedientes.DetailExpedienteService;

/**
 * 
 *  
 *
 */
public class ProcedureActionFacade {

	private static ProcedureActionFacade instance;

	private Map<String, ProcedureActions> proceduresActions = new HashMap<String, ProcedureActions>(6);

	private ProcedureActionFacade() {
	}

	public static ProcedureActionFacade getInstance() {
		if (instance == null) {
			instance = new ProcedureActionFacade();
		}
		return instance;
	}

	/**
	 * Obtiene el objeto responsable de las acciones sobre el expediente de la
	 * ficha para cada procedimiento
	 * 
	 * @param codProcedure
	 * @param expedienteService
	 * @return
	 */
	public ProcedureActions getProcedureAction(String codProcedure, DetailExpedienteService expedienteService) {
		if (proceduresActions.isEmpty()) {
			initProceduresActions(expedienteService);
		}
		return proceduresActions.get(codProcedure);
	}

	/**
	 * Carga en memoria los Procedure Action para los procedimiento
	 * 
	 * @param expedienteService
	 */
	private void initProceduresActions(DetailExpedienteService expedienteService) {
		proceduresActions.put(Constantes.PROCEDIMIENTO_DESCONOCIDO, new DefaultProcedureActions(expedienteService));
		proceduresActions.put(Constantes.PROCEDIMIENTO_DENUNCIA_TURISMO,
				new DenunciaProcedureActions(Constantes.PROCEDIMIENTO_DENUNCIA_TURISMO, expedienteService));
		proceduresActions.put(Constantes.PROCEDIMIENTO_DENUNCIA_COMERCIO,
				new DenunciaProcedureActions(Constantes.PROCEDIMIENTO_DENUNCIA_COMERCIO, expedienteService));
		proceduresActions.put(Constantes.PROCEDIMIENTO_DENUNCIA_TUQ,
				new DenunciaProcedureActions(Constantes.PROCEDIMIENTO_DENUNCIA_TUQ, expedienteService));
		proceduresActions.put(Constantes.PROCEDIMIENTO_DENUNCIA_NO_FORMAL,
				new DenunciaProcedureActions(Constantes.PROCEDIMIENTO_DENUNCIA_NO_FORMAL, expedienteService));

	}

	public ProcedureActions getDefault() {
		return proceduresActions.get(Constantes.PROCEDIMIENTO_DESCONOCIDO);
	}
}
