package com.ejie.ab78.service.procedimientos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.procedimientos.ProcedimientosDao;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

@Service(value = "procedimientosService")
public class ProcedimientosServiceImpl implements ProcedimientosService {

	@Autowired
	private ProcedimientosDao procedimientosDao;

	/**
	 * Inserts a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Procedimientos add(Procedimientos procedimientos) {
		return this.procedimientosDao.add(procedimientos);
	}

	/**
	 * Updates a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Procedimientos update(Procedimientos procedimientos) {
		return this.procedimientosDao.update(procedimientos);
	}

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	public Procedimientos find(Procedimientos procedimientos) {
		return (Procedimientos) this.procedimientosDao.find(procedimientos);
	}

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	public Procedimientos findProc(Procedimientos procedimientos) {
		return (Procedimientos) this.procedimientosDao.findProc(procedimientos);
	}

	/**
	 * Deletes a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Procedimientos procedimientos) {
		this.procedimientosDao.remove(procedimientos);
	}

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	public List<Procedimientos> findAll(Procedimientos procedimientos, TableRequestDto TableRequestDto) {
		return (List<Procedimientos>) this.procedimientosDao.findAll(procedimientos, TableRequestDto);
	}

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	public List<Procedimientos> findAllCenso(Procedimientos procedimientos) {
		return (List<Procedimientos>) this.procedimientosDao.findAllCenso(procedimientos);
	}

	/**
	 * Finds a list of rows in the Procedimientos table for Tabla Maestro.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */

	/**
	 * Finds rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Procedimientos>
	 */
	public List<Procedimientos> findAllLike(Procedimientos procedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return (List<Procedimientos>) this.procedimientosDao.findAllLike(procedimientos, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		this.procedimientosDao.removeMultiple(filterProcedimientos, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Procedimientos>
	 */
	public TableResponseDto<Procedimientos> filter(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<Procedimientos> listaProcedimientos = this.procedimientosDao.findAllLike(filterProcedimientos,
				TableRequestDto, false);
		Long recordNum = this.procedimientosDao
				.findAllLikeCount(filterProcedimientos != null ? filterProcedimientos : new Procedimientos(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Procedimientos>> reorderSelection = this.procedimientosDao
					.reorderSelection(filterProcedimientos, TableRequestDto, startsWith);
			return new TableResponseDto<Procedimientos>(TableRequestDto, recordNum, listaProcedimientos,
					reorderSelection);
		}
		return new TableResponseDto<Procedimientos>(TableRequestDto, recordNum, listaProcedimientos);
	}

	/**
	 * Searches rows in the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param searchProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	public List<TableRowDto<Procedimientos>> search(Procedimientos filterProcedimientos,
			Procedimientos searchProcedimientos, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.procedimientosDao.search(filterProcedimientos, searchProcedimientos, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.procedimientosDao.reorderSelection(filterProcedimientos, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Procedimientos>>
	 */
	public TableResponseDto<JerarquiaDto<Procedimientos>> jerarquia(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Procedimientos>> listaProcedimientos = this.procedimientosDao
				.findAllLikeJerarquia(filterProcedimientos, TableRequestDto);
		Long recordNum = this.procedimientosDao.findAllLikeCountJerarquia(filterProcedimientos, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<Procedimientos>>(TableRequestDto, recordNum, listaProcedimientos);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Procedimientos
	 * table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Procedimientos>>
	 */
	public TableResponseDto<JerarquiaDto<Procedimientos>> jerarquiaChildren(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<Procedimientos>> TableResponseDto = new TableResponseDto<JerarquiaDto<Procedimientos>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.procedimientosDao.findAllChild(filterProcedimientos, TableRequestDto));
		return TableResponseDto;
	}

	@Override
	public List<Procedimientos> findAllTablaMaestro(Procedimientos procedimientos, Integer idDireccion, Boolean startsWith) {
		// TODO Auto-generated method stub
		return this.procedimientosDao.findAllTablaMaestro(procedimientos, idDireccion, startsWith);
	}

}
