package com.ejie.ab78.service.procedimientos;

import java.util.List;

import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

public interface ProcedimientosService {

	/**
	 * Inserts a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos add(Procedimientos procedimientos);

	/**
	 * Updates a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos update(Procedimientos procedimientos);

	Procedimientos find(Procedimientos procedimientos);

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos findProc(Procedimientos procedimientos);

	/**
	 * Deletes a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 */
	void remove(Procedimientos procedimientos);

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	List<Procedimientos> findAll(Procedimientos procedimientos, TableRequestDto TableRequestDto);

	List<Procedimientos> findAllCenso(Procedimientos procedimientos);

	List<Procedimientos> findAllTablaMaestro(Procedimientos procedimientos, Integer idDireccion, Boolean startsWith);

	/**
	 * Finds rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Procedimientos>
	 */
	List<Procedimientos> findAllLike(Procedimientos procedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Procedimientos>
	 */
	TableResponseDto<Procedimientos> filter(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param searchProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	List<TableRowDto<Procedimientos>> search(Procedimientos filterProcedimientos, Procedimientos searchProcedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Procedimientos>>
	 */
	TableResponseDto<JerarquiaDto<Procedimientos>> jerarquia(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Procedimientos
	 * table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Procedimientos>>
	 */
	TableResponseDto<JerarquiaDto<Procedimientos>> jerarquiaChildren(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto);

}
