package com.ejie.ab78.service.procedimientos;

import java.util.HashMap;
import java.util.Map;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.RelExpTer;
import com.ejie.ab78.service.expedientes.DetailExpedienteService;

public class DenunciaProcedureActions extends BaseProcedureActions {

	protected DenunciaProcedureActions(String procedimiento, DetailExpedienteService detailExpedienteService) {
		super(procedimiento, detailExpedienteService);
	}

	@Override
	public Boolean isEnableExecuteAction(Expedientes form) {
		return super.isEnableSaveExpediente(form);
	}

	@Override
	public DatosDirecciones findDireccioneDenunciado(Expedientes form) {
		Denuncia denuncia = new Denuncia();
		denuncia.setExpediente(form);
		denuncia = this.getDetailExpedienteService().getDenunciasService().findByIdExpediente(denuncia);

		return this.getDetailExpedienteService().getDatosDireccionesService().find(denuncia.getIdDireccionDenunciado());
	}

	@Override
	public Denuncia findDenuncia(Expedientes form) {
		Denuncia filter = new Denuncia();
		filter.setExpediente(form);
		return getDetailExpedienteService().getDenunciasService().findByIdExpediente(filter);
	}

	@Override
	public Map<String, String> executeAction(Expedientes form, Denuncia denuncia) {
		this.getDetailExpedienteService().getDenunciasService().update(denuncia);
		String[] subtipoParticipacion = denuncia.getSubtipoParticipacion();
		if (subtipoParticipacion != null) {
			for (int i = 0; i < subtipoParticipacion.length; i++) {
				String participacion = subtipoParticipacion[i];
				String idRelRecTer = participacion.split("#")[0];
				String idSubtipo = participacion.split("#")[1];
				RelExpTer expTer = new RelExpTer();
				expTer.setIdExpediente(form.getIdExpediente());
				expTer.setIdRelExpTer(Integer.parseInt(idRelRecTer));
				if ("0".equalsIgnoreCase(idSubtipo)) {
					expTer.setIdSubtipo(null);
				} else {
					expTer.setIdSubtipo(Integer.parseInt(idSubtipo));
				}
				this.getDetailExpedienteService().getRelExpTerService().updateSubtipo(expTer);
			}
		}

		return new HashMap<String, String>();
	}

	@Override
	public String getButtonsText(Expedientes form) {
		StringBuilder buffer = new StringBuilder();
		buffer.append(form.getProcedimientos().getCodProcedureId());
		return buffer.toString();
	}

	@Override
	public Boolean isEnableAccessInspecciones(Expedientes form) {
		return this.getDetailExpedienteService().getExpedientesService().hasInspeccion(form.getIdExpediente());
	}

	@Override
	public Boolean isEnableInspect(Expedientes form) {
		return !isEnableAccessInspecciones(form);
	}

	@Override
	public Boolean isInspectionable(Expedientes form) {
		Procedimientos procedimiento = new Procedimientos();

		ProcedimientosService procedimientoService = this.getDetailExpedienteService().getProcedimientosService();
		procedimiento = procedimientoService.find(form.getProcedimientos());
		String inspeccionable = procedimiento.getInspeccionable();
		return "1".equals(inspeccionable);
	}

}
