package com.ejie.ab78.service.procedimientos;

import java.util.HashMap;
import java.util.Map;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.service.expedientes.DetailExpedienteService;

/**
 * 
 *  
 *
 */
public class DefaultProcedureActions extends BaseProcedureActions {

	protected DefaultProcedureActions(DetailExpedienteService detailExpedienteService) {
		super(Constantes.PROCEDIMIENTO_DESCONOCIDO, detailExpedienteService);
	}

	@Override
	public DatosDirecciones findDireccioneDenunciado(Expedientes form) {
		return this.getDetailExpedienteService().getDatosDireccionesService()
				.findEstablecimientoExpediente(form.getIdExpediente());
	}

	@Override
	public Denuncia findDenuncia(Expedientes form) {
		Denuncia filter = new Denuncia();
		filter.setExpediente(form);
		return getDetailExpedienteService().getDenunciasService().findByIdExpediente(filter);
	}

	@Override
	public Boolean isEnableSaveExpediente(Expedientes initForm) {
		return false;
	}

	@Override
	public Boolean isEnableExecuteAction(Expedientes form) {
		return false;
	}

	@Override
	public Boolean isEnableAccessCenso(Expedientes form) {
		return false;
	}

	@Override
	public Boolean isEnableInspect(Expedientes form) {
		return false;
	}

	@Override
	public Map<String, String> executeAction(Expedientes form, Denuncia denuncia) {
		return new HashMap<String, String>();
	}

	@Override
	public String getButtonsText(Expedientes form) {
		return Constantes.PROCEDIMIENTO_DESCONOCIDO;
	}

}
