package com.ejie.ab78.service.procedimientos;

import java.util.List;
import java.util.Map;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.ab78.service.expedientes.DetailExpedienteService;
import com.ejie.ab78.service.expedientes.ExpedientesService;

/**
 * 
 *  
 *
 */
public abstract class BaseProcedureActions implements ProcedureActions {

	private String procedimiento;

	private DetailExpedienteService detailExpedienteService;

	protected BaseProcedureActions(String procedimiento, DetailExpedienteService detailExpedienteService) {
		this.procedimiento = procedimiento;
		this.detailExpedienteService = detailExpedienteService;
	}

	public abstract Map<String, String> executeAction(Expedientes form, Denuncia denuncia);

	public abstract String getButtonsText(Expedientes form);

	@Override
	public Boolean hasSecondButton(Expedientes form) {
		return false;
	}

	/**
	 * Los expediente que indicaron un identificador, son asociados al
	 * establecimiento
	 * 
	 * @param Expedientes
	 * @return
	 */

	public Boolean isEnableSaveExpediente(Expedientes expediente) {
		Boolean result = true;
		expediente = this.detailExpedienteService.getExpedientesService().find(expediente);

		if (expediente == null) {
			result = false;
		}
		/**
		 *  Si el expediente ya esta cerrado no se puede guardar
		 *  
		 *  Permitiremos que aunque el expediente este cerrado se puedan guardar los cambios
		 */
//		if (result && this.detailExpedienteService.getExpedientesService().checkIsClosed(expediente)) {
//			result = false;
//		}
		
		if (result && expediente.getProcedimientos() == null) {
			result = false;
		}

		return result;
	}

	protected boolean isEmptyIdentificador(Expedientes initForm) {
		Denuncia denuncia = findDenuncia(initForm);
		return denuncia == null || denuncia.getDireccionDenunciado() == null
				|| denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento()== null || "".equals(denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento());
	}

	public Boolean isEnableAccessCenso(Expedientes form) {
		return !isEmptyIdentificador(form);
	}

	public Boolean isEnableCreateDocs(Expedientes form) {
		if (form.getFolderId() == null) {
			return false;
		}
		return true;
	}

	public String getProcedimiento() {
		return procedimiento;
	}

	public void setProcedimiento(String procedimiento) {
		this.procedimiento = procedimiento;
	}

	public DetailExpedienteService getDetailExpedienteService() {
		return detailExpedienteService;
	}

	public void setDetailExpedienteService(DetailExpedienteService detailExpedienteService) {
		this.detailExpedienteService = detailExpedienteService;
	}

	@Override
	public List<String> getPestanaConfig() {
		return Constantes.getMapPestanasByProcedure().get(procedimiento);
	}

	@Override
	public Boolean isEnableShowUbicacionEstablecimiento(Expedientes form) {
		return true;
	}

	@Override
	public Boolean isEnableAccessInspecciones(Expedientes form) {
		return this.getDetailExpedienteService().getExpedientesService().hasInspectExpedient(form.getIdExpediente());
	}

	@Override
	public Boolean isEnableInspect(Expedientes form) {
		Boolean isEnableSend = !this.getDetailExpedienteService().getExpedientesService()
				.hasInspectExpedient(form.getIdExpediente());
		return isEnableSend;
	}

	@Override
	public Boolean isInspectionable(Expedientes form) {
		Procedimientos procedimiento = new Procedimientos();

		ProcedimientosService procedimientoService = this.getDetailExpedienteService().getProcedimientosService();
		procedimiento = procedimientoService.find(form.getProcedimientos());
		String inspeccionable = procedimiento.getInspeccionable();
		return "1".equals(inspeccionable);
	}

	public Boolean isCloseExpediente(Expedientes form) {
		// pasarle el expediente me devuelve si esta cerrado o no
		ExpedientesService expedientesService = this.detailExpedienteService.getExpedientesService();
		return expedientesService.checkIsClosed(new Expedientes(form.getIdExpediente()));
	}

}
