package com.ejie.ab78.service.plantillas;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.plantillas.TiposPlantillaDao;
import com.ejie.ab78.model.plantillas.TiposPlantilla;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposPlantillaServiceImpl  
 * 
 *  
 */

@Service(value = "tiposPlantillaService")
public class TiposPlantillaServiceImpl implements TiposPlantillaService {

	@Autowired
	private TiposPlantillaDao tiposPlantillaDao;

	/**
	 * Inserts a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposPlantilla add(TiposPlantilla tiposPlantilla) {
		return this.tiposPlantillaDao.add(tiposPlantilla);
	}

	/**
	 * Updates a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposPlantilla update(TiposPlantilla tiposPlantilla) {
		return this.tiposPlantillaDao.update(tiposPlantilla);
	}

	/**
	 * Finds a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	public TiposPlantilla find(TiposPlantilla tiposPlantilla) {
		return (TiposPlantilla) this.tiposPlantillaDao.find(tiposPlantilla);
	}

	/**
	 * Deletes a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TiposPlantilla tiposPlantilla) {
		this.tiposPlantillaDao.remove(tiposPlantilla);
	}

	/**
	 * Finds a list of rows in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposPlantilla>
	 */
	public List<TiposPlantilla> findAll(TiposPlantilla tiposPlantilla, TableRequestDto TableRequestDto) {
		return (List<TiposPlantilla>) this.tiposPlantillaDao.findAll(tiposPlantilla, TableRequestDto);
	}

	/**
	 * Finds rows in the TiposPlantilla table using like.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposPlantilla>
	 */
	public List<TiposPlantilla> findAllLike(TiposPlantilla tiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return (List<TiposPlantilla>) this.tiposPlantillaDao.findAllLike(tiposPlantilla, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		this.tiposPlantillaDao.removeMultiple(filterTiposPlantilla, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposPlantilla>
	 */
	public TableResponseDto<TiposPlantilla> filter(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<TiposPlantilla> listaTiposPlantilla = this.tiposPlantillaDao.findAllLike(filterTiposPlantilla,
				TableRequestDto, false);
		Long recordNum = this.tiposPlantillaDao
				.findAllLikeCount(filterTiposPlantilla != null ? filterTiposPlantilla : new TiposPlantilla(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TiposPlantilla>> reorderSelection = this.tiposPlantillaDao
					.reorderSelection(filterTiposPlantilla, TableRequestDto, startsWith);
			return new TableResponseDto<TiposPlantilla>(TableRequestDto, recordNum, listaTiposPlantilla,
					reorderSelection);
		}
		return new TableResponseDto<TiposPlantilla>(TableRequestDto, recordNum, listaTiposPlantilla);
	}

	/**
	 * Searches rows in the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param searchTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	public List<TableRowDto<TiposPlantilla>> search(TiposPlantilla filterTiposPlantilla,
			TiposPlantilla searchTiposPlantilla, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.tiposPlantillaDao.search(filterTiposPlantilla, searchTiposPlantilla, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.tiposPlantillaDao.reorderSelection(filterTiposPlantilla, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposPlantilla>>
	 */
	public TableResponseDto<JerarquiaDto<TiposPlantilla>> jerarquia(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<TiposPlantilla>> listaTiposPlantilla = this.tiposPlantillaDao
				.findAllLikeJerarquia(filterTiposPlantilla, TableRequestDto);
		Long recordNum = this.tiposPlantillaDao.findAllLikeCountJerarquia(filterTiposPlantilla, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<TiposPlantilla>>(TableRequestDto, recordNum, listaTiposPlantilla);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the TiposPlantilla
	 * table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposPlantilla>>
	 */
	public TableResponseDto<JerarquiaDto<TiposPlantilla>> jerarquiaChildren(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<TiposPlantilla>> TableResponseDto = new TableResponseDto<JerarquiaDto<TiposPlantilla>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.tiposPlantillaDao.findAllChild(filterTiposPlantilla, TableRequestDto));
		return TableResponseDto;
	}

}
