package com.ejie.ab78.service.plantillas;

import java.util.List;

import com.ejie.ab78.model.plantillas.TiposPlantilla;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposPlantillaService  
 * 
 *  
 */

public interface TiposPlantillaService {

	/**
	 * Inserts a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla add(TiposPlantilla tiposPlantilla);

	/**
	 * Updates a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla update(TiposPlantilla tiposPlantilla);

	/**
	 * Finds a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla find(TiposPlantilla tiposPlantilla);

	/**
	 * Deletes a single row in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 */
	void remove(TiposPlantilla tiposPlantilla);

	/**
	 * Finds a list of rows in the TiposPlantilla table.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposPlantilla>
	 */
	List<TiposPlantilla> findAll(TiposPlantilla tiposPlantilla, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposPlantilla table using like.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposPlantilla>
	 */
	List<TiposPlantilla> findAllLike(TiposPlantilla tiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TiposPlantilla>
	 */
	TableResponseDto<TiposPlantilla> filter(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param searchTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	List<TableRowDto<TiposPlantilla>> search(TiposPlantilla filterTiposPlantilla, TiposPlantilla searchTiposPlantilla,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TiposPlantilla>>
	 */
	TableResponseDto<JerarquiaDto<TiposPlantilla>> jerarquia(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the TiposPlantilla
	 * table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TiposPlantilla>>
	 */
	TableResponseDto<JerarquiaDto<TiposPlantilla>> jerarquiaChildren(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto);

}
