package com.ejie.ab78.service.plantillas;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.adaptadores.ab61WebServiceAdaptadorService;
import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.clientesWS.ab61WebService.Usuario;
import com.ejie.ab78.dao.plantillas.PlantillasDao;
import com.ejie.ab78.model.plantillas.Plantillas;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PlantillasServiceImpl  
 * 
 *  
 */

@Service(value = "plantillasService")
public class PlantillasServiceImpl implements PlantillasService {

	@Autowired
	private PlantillasDao plantillasDao;

	@Autowired
	private ab61WebServiceAdaptadorService ab61WebServiceAdaptadorService;

	/**
	 * Finds a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	public Plantillas find(Plantillas plantillas) {
		return (Plantillas) this.plantillasDao.find(plantillas);
	}

	/**
	 * Deletes a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Plantillas plantillas) {
		this.plantillasDao.remove(plantillas);
	}

	/**
	 * Finds a list of rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Plantillas>
	 */
	public List<Plantillas> findAll(Plantillas plantillas, TableRequestDto TableRequestDto) {
		return (List<Plantillas>) this.plantillasDao.findAll(plantillas, TableRequestDto);
	}

	/**
	 * Finds rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Plantillas>
	 */
	public List<Plantillas> findAllLike(Plantillas plantillas, TableRequestDto TableRequestDto, Boolean startsWith) {
		return (List<Plantillas>) this.plantillasDao.findAllLike(plantillas, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Plantillas filterPlantillas, TableRequestDto TableRequestDto, Boolean startsWith) {
		this.plantillasDao.removeMultiple(filterPlantillas, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Plantillas>
	 */
	public TableResponseDto<Plantillas> filter(Plantillas filterPlantillas, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		List<Plantillas> listaPlantillas = this.plantillasDao.findAllLike(filterPlantillas, TableRequestDto, false);
		Long recordNum = this.plantillasDao
				.findAllLikeCount(filterPlantillas != null ? filterPlantillas : new Plantillas(), false);
		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Plantillas>> reorderSelection = this.plantillasDao.reorderSelection(filterPlantillas,
					TableRequestDto, startsWith);
			return new TableResponseDto<Plantillas>(TableRequestDto, recordNum, listaPlantillas, reorderSelection);
		}
		return new TableResponseDto<Plantillas>(TableRequestDto, recordNum, listaPlantillas);
	}

	/**
	 * Searches rows in the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param searchPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	public List<TableRowDto<Plantillas>> search(Plantillas filterPlantillas, Plantillas searchPlantillas,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.plantillasDao.search(filterPlantillas, searchPlantillas, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Plantillas filterPlantillas, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.plantillasDao.reorderSelection(filterPlantillas, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Plantillas>>
	 */
	public TableResponseDto<JerarquiaDto<Plantillas>> jerarquia(Plantillas filterPlantillas,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Plantillas>> listaPlantillas = this.plantillasDao.findAllLikeJerarquia(filterPlantillas,
				TableRequestDto);
		Long recordNum = this.plantillasDao.findAllLikeCountJerarquia(filterPlantillas, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<Plantillas>>(TableRequestDto, recordNum, listaPlantillas);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Plantillas>>
	 */
	public TableResponseDto<JerarquiaDto<Plantillas>> jerarquiaChildren(Plantillas filterPlantillas,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<Plantillas>> TableResponseDto = new TableResponseDto<JerarquiaDto<Plantillas>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.plantillasDao.findAllChild(filterPlantillas, TableRequestDto));
		return TableResponseDto;
	}

	/**
	 * llama al webService que realiza la tarea indicada
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param usuario
	 *            Usuario
	 * @return String
	 * @throws Ab61Exception
	 */
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception {

		return ab61WebServiceAdaptadorService.aportarDocumentoPlatea(idPlantilla, procedureId, folderId, usuario);
	}

}
