package com.ejie.ab78.service.plantillas;

import java.util.List;

import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.model.plantillas.Plantillas;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PlantillasService  
 * 
 *  
 */

public interface PlantillasService {

	/**
	 * Finds a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	Plantillas find(Plantillas plantillas);

	/**
	 * Deletes a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 */
	void remove(Plantillas plantillas);

	/**
	 * Finds a list of rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Plantillas>
	 */
	List<Plantillas> findAll(Plantillas plantillas, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Plantillas>
	 */
	List<Plantillas> findAllLike(Plantillas plantillas, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Plantillas filterPlantillas, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Plantillas>
	 */
	TableResponseDto<Plantillas> filter(Plantillas filterPlantillas, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param searchPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	List<TableRowDto<Plantillas>> search(Plantillas filterPlantillas, Plantillas searchPlantillas,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Plantillas filterPlantillas, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Plantillas>>
	 */
	TableResponseDto<JerarquiaDto<Plantillas>> jerarquia(Plantillas filterPlantillas, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Plantillas>>
	 */
	TableResponseDto<JerarquiaDto<Plantillas>> jerarquiaChildren(Plantillas filterPlantillas,
			TableRequestDto TableRequestDto);
}
