package com.ejie.ab78.service.nora;

import java.util.List;

import com.ejie.ab78.model.nora.T17TipoVia;
import com.ejie.x38.dto.Pagination;

/**
 * T17TipoViaService  
 * 
 *  
 */

public interface T17TipoViaService {

	/**
	 * Inserts a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia add(T17TipoVia t17TipoVia);

	/**
	 * Updates a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia update(T17TipoVia t17TipoVia);

	/**
	 * Finds a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia find(T17TipoVia t17TipoVia);

	/**
	 * Finds a List of rows in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17TipoVia> findAll(T17TipoVia t17TipoVia, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return Long
	 */
	Long findAllCount(T17TipoVia t17TipoVia);

	/**
	 * Finds rows in the T17TipoVia table using like.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<T17TipoVia> findAllLike(T17TipoVia t17TipoVia, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Counts rows in the T17TipoVia table using like.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(T17TipoVia t17TipoVia, Boolean startsWith);

	/**
	 * Deletes a single row in the T17TipoVia table.
	 * 
	 * @param t17TipoVia
	 *            T17TipoVia
	 * @return
	 */
	void remove(T17TipoVia t17TipoVia);

	/**
	 * Deletes multiple rows in the T17TipoVia table.
	 * 
	 * @param t17TipoViaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<T17TipoVia> t17TipoViaList);

}
