package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab78.model.nora.T17Provincia;
import com.ejie.x38.dto.Pagination;

/**
 * T17ProvinciaService  
 * 
 *  
 */
public interface T17ProvinciaService {

	/**
	 * Inserts a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia add(T17Provincia t17Provincia);

	/**
	 * Updates a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia update(T17Provincia t17Provincia);

	/**
	 * Finds a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia find(T17Provincia t17Provincia);

	/**
	 * Finds a List of rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Provincia> findAll(T17Provincia t17Provincia, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return Long
	 */
	Long findAllCount(T17Provincia t17Provincia);

	/**
	 * Finds rows in the T17Provincia table using like.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Provincia>
	 */
	List<T17Provincia> findAllLike(T17Provincia t17Provincia, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 */
	void remove(T17Provincia t17Provincia);

	/**
	 * Deletes multiple rows in the T17Provincia table.
	 * 
	 * @param t17ProvinciaList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Provincia> t17ProvinciaList);
	
	List<T17Provincia> findProvinciasVascas();

}
