package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab78.model.nora.T17Municipio;
import com.ejie.x38.dto.Pagination;

/**
 * T17MunicipioService  
 * 
 *  
 */
public interface T17MunicipioService {

	/**
	 * Inserts a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio add(T17Municipio t17Municipio);

	/**
	 * Updates a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio update(T17Municipio t17Municipio);

	/**
	 * Finds a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	T17Municipio find(T17Municipio t17Municipio);

	/**
	 * Finds a List of rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Municipio> findAll(T17Municipio t17Municipio, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return Long
	 */
	Long findAllCount(T17Municipio t17Municipio);

	/**
	 * Finds rows in the T17Municipio table using like.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<T17Municipio> findAllLike(T17Municipio t17Municipio, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 */
	void remove(T17Municipio t17Municipio);

	/**
	 * Deletes multiple rows in the T17Municipio table.
	 * 
	 * @param t17MunicipioList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Municipio> t17MunicipioList);

}
