package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.nora.T17LocalidadDao;
import com.ejie.ab78.model.nora.T17Localidad;
import com.ejie.x38.dto.Pagination;

/**
 * T17LocalidadServiceImpl  
 * 
 *  
 */
@Service(value = "t17LocalidadService")
public class T17LocalidadServiceImpl implements T17LocalidadService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory.getLogger(T17LocalidadServiceImpl.class);
	@Autowired()
	private T17LocalidadDao t17LocalidadDao;

	/**
	 * Inserts a single row in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return T17Localidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Localidad add(T17Localidad t17Localidad) {
		return this.t17LocalidadDao.add(t17Localidad);
	}

	/**
	 * Updates a single row in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return T17Localidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Localidad update(T17Localidad t17Localidad) {
		return this.t17LocalidadDao.update(t17Localidad);
	}

	/**
	 * Finds a single row in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return T17Localidad
	 */
	public T17Localidad find(T17Localidad t17Localidad) {
		return (T17Localidad) this.t17LocalidadDao.find(t17Localidad);
	}

	/**
	 * Finds a List of rows in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination<Object>
	 * 
	 * @return List<T17Localidad>
	 */
	public List<T17Localidad> findAll(T17Localidad t17Localidad, Pagination<Object> pagination) {
		return (List<T17Localidad>) this.t17LocalidadDao.findAll(t17Localidad, pagination);
	}

	/**
	 * Counts rows in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return Long
	 */
	public Long findAllCount(T17Localidad t17Localidad) {
		return this.t17LocalidadDao.findAllCount(t17Localidad);
	}

	/**
	 * Finds rows in the T17Localidad table using like.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<T17Localidad> findAllLike(T17Localidad t17Localidad, Pagination<Object> pagination,
			Boolean startsWith) {
		return (List<T17Localidad>) this.t17LocalidadDao.findAllLike(t17Localidad, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Localidad t17Localidad) {
		this.t17LocalidadDao.remove(t17Localidad);
	}

	/**
	 * Deletes multiple rows in the T17Localidad table.
	 * 
	 * @param t17LocalidadList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Localidad> t17LocalidadList) {
		for (T17Localidad t17LocalidadAux : t17LocalidadList) {
			this.t17LocalidadDao.remove(t17LocalidadAux);
		}
	}

	/**
	 * 
	 * @return T17LocalidadDao
	 */
	public T17LocalidadDao getT17LocalidadDao() {
		return this.t17LocalidadDao;
	}

	/**
	 * 
	 * @param t17LocalidadDao
	 *            T17LocalidadDao
	 */
	public void setT17LocalidadDao(T17LocalidadDao t17LocalidadDao) {
		T17LocalidadServiceImpl.logger.info("Setting Dependency " + t17LocalidadDao);
		this.t17LocalidadDao = t17LocalidadDao;
	}
}
