package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab78.model.nora.T17Comarca;
import com.ejie.x38.dto.Pagination;

/**
 * T17ComarcaService  
 * 
 *  
 */
public interface T17ComarcaService {

	/**
	 * Inserts a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca add(T17Comarca t17Comarca);

	/**
	 * Updates a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca update(T17Comarca t17Comarca);

	/**
	 * Finds a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca find(T17Comarca t17Comarca);

	/**
	 * Finds a List of rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Comarca> findAll(T17Comarca t17Comarca, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return Long
	 */
	Long findAllCount(T17Comarca t17Comarca);

	/**
	 * Finds rows in the T17Comarca table using like.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Comarca>
	 */
	List<T17Comarca> findAllLike(T17Comarca t17Comarca, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 */
	void remove(T17Comarca t17Comarca);

	/**
	 * Deletes multiple rows in the T17Comarca table.
	 * 
	 * @param t17ComarcaList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Comarca> t17ComarcaList);

}
