package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab78.model.nora.T17Calle;
import com.ejie.ab78.model.nora.T17Portal;
import com.ejie.x38.dto.Pagination;

/**
 * T17CalleService  
 * 
 *  
 */
public interface T17CalleService {

	/**
	 * Inserts a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle add(T17Calle T17Calle);

	/**
	 * Updates a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle update(T17Calle T17Calle);

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle find(T17Calle T17Calle);

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Calle> findAll(T17Calle T17Calle, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return Long
	 */
	Long findAllCount(T17Calle T17Calle);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Calle>
	 */
	List<T17Calle> findAllLike(T17Calle T17Calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Calle>
	 */
	List<T17Calle> findAllLikeCalle(T17Calle T17Calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 */
	void remove(T17Calle T17Calle);

	/**
	 * Deletes multiple rows in the T17Calle table.
	 * 
	 * @param T17CalleList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Calle> T17CalleList);

	/**
	 * Busca la provincia y municipio asociado al codigo postal.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Calle findProvMun(T17Portal t17Portal);

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Calle>
	 */
	List<T17Calle> findAllCalleLike(T17Calle T17Calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return Long
	 */
	Long findAllCalleLikeCount(T17Calle T17Calle, Boolean startsWith);
}
