package com.ejie.ab78.service.nora;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.nora.T17AutonomiaDao;
import com.ejie.ab78.model.nora.T17Autonomia;
import com.ejie.x38.dto.Pagination;

/**
 * T17AutonomiaServiceImpl  
 * 
 *  
 */
@Service(value = "t17AutonomiaService")
public class T17AutonomiaServiceImpl implements T17AutonomiaService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory.getLogger(T17AutonomiaServiceImpl.class);

	@Autowired()
	private T17AutonomiaDao t17AutonomiaDao;

	/**
	 * Inserts a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Autonomia add(T17Autonomia t17Autonomia) {
		return this.t17AutonomiaDao.add(t17Autonomia);
	}

	/**
	 * Updates a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Autonomia update(T17Autonomia t17Autonomia) {
		return this.t17AutonomiaDao.update(t17Autonomia);
	}

	/**
	 * Finds a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	public T17Autonomia find(T17Autonomia t17Autonomia) {
		return (T17Autonomia) this.t17AutonomiaDao.find(t17Autonomia);
	}

	/**
	 * Finds a List of rows in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination<Object>
	 * 
	 * @return List<T17Autonomia>
	 */
	public List<T17Autonomia> findAll(T17Autonomia t17Autonomia, Pagination<Object> pagination) {
		return (List<T17Autonomia>) this.t17AutonomiaDao.findAll(t17Autonomia, pagination);
	}

	/**
	 * Counts rows in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @return Long
	 */
	public Long findAllCount(T17Autonomia t17Autonomia) {
		return this.t17AutonomiaDao.findAllCount(t17Autonomia);
	}

	/**
	 * Finds rows in the T17Autonomia table using like.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Autonomia>
	 */
	public List<T17Autonomia> findAllLike(T17Autonomia t17Autonomia, Pagination<Object> pagination,
			Boolean startsWith) {
		return (List<T17Autonomia>) this.t17AutonomiaDao.findAllLike(t17Autonomia, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Autonomia table.
	 * 
	 * @param t17Autonomia
	 *            T17Autonomia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Autonomia t17Autonomia) {
		this.t17AutonomiaDao.remove(t17Autonomia);
	}

	/**
	 * Deletes multiple rows in the T17Autonomia table.
	 * 
	 * @param t17AutonomiaList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Autonomia> t17AutonomiaList) {
		for (T17Autonomia t17AutonomiaAux : t17AutonomiaList) {
			this.t17AutonomiaDao.remove(t17AutonomiaAux);
		}
	}

	/**
	 * 
	 * @return T17AutonomiaDao
	 */
	public T17AutonomiaDao getT17AutonomiaDao() {
		return this.t17AutonomiaDao;
	}

	/**
	 * 
	 * @param t17AutonomiaDao
	 *            T17AutonomiaDao
	 */
	public void setT17AutonomiaDao(T17AutonomiaDao t17AutonomiaDao) {
		T17AutonomiaServiceImpl.logger.info("Setting Dependency " + t17AutonomiaDao);
		this.t17AutonomiaDao = t17AutonomiaDao;
	}
}
