package com.ejie.ab78.service.maestros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.TipoVentasDao;
import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasServiceImpl  
 * 
 *  
 */

@Service(value = "ab7804s00Service")
public class TipoVentasServiceImpl implements TipoVentasService {

	@Autowired
	private TipoVentasDao tipoVentasDao;

	/**
	 * Inserts a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoVenta add(TipoVenta tipoVenta) {
		return this.tipoVentasDao.add(tipoVenta);
	}

	/**
	 * Updates a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoVenta update(TipoVenta tipoVenta) {
		return this.tipoVentasDao.update(tipoVenta);
	}

	/**
	 * Finds a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	public TipoVenta find(TipoVenta tipoVenta) {
		return (TipoVenta) this.tipoVentasDao.find(tipoVenta);
	}

	/**
	 * Deletes a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoVenta tipoVenta) {
		this.tipoVentasDao.remove(tipoVenta);
	}

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	public List<TipoVenta> findAll(TipoVenta tipoVenta, TableRequestDto tableRequestDto) {
		return (List<TipoVenta>) this.tipoVentasDao.findAll(tipoVenta, tableRequestDto);
	}

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	public List<TipoVenta> findAllFilterProcedimiento(TipoVenta tipoVenta, TableRequestDto tableRequestDto) {
		return (List<TipoVenta>) this.tipoVentasDao.findAllFilterProcedimiento(tipoVenta, tableRequestDto);
	}

	/**
	 * Finds rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoVenta>
	 */
	public List<TipoVenta> findAllLike(TipoVenta tipoVenta, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<TipoVenta>) this.tipoVentasDao.findAllLike(tipoVenta, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.tipoVentasDao.removeMultiple(filterAb7804s00, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TipoVenta>
	 */
	public TableResponseDto<TipoVenta> filter(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<TipoVenta> listaAb7804s00 = this.tipoVentasDao.findAllLike(filterAb7804s00, tableRequestDto, false);
		Long recordNum = this.tipoVentasDao
				.findAllLikeCount(filterAb7804s00 != null ? filterAb7804s00 : new TipoVenta(), false);

		TableResponseDto<TipoVenta> usuarioDto = new TableResponseDto<TipoVenta>(tableRequestDto, recordNum,
				listaAb7804s00);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TipoVenta>> reorderSelection = this.tipoVentasDao.reorderSelection(filterAb7804s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<TipoVenta>> reorderSeeker = this.tipoVentasDao.reorderSelection(filterAb7804s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param searchAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	public List<TableRowDto<TipoVenta>> search(TipoVenta filterAb7804s00, TipoVenta searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.tipoVentasDao.search(filterAb7804s00, searchAb7804s00, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.tipoVentasDao.reorderSelection(filterAb7804s00, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>>
	 */
	public TableResponseDto<JerarquiaDto<TipoVenta>> jerarquia(TipoVenta filterAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<TipoVenta>> listaAb7804s00 = this.tipoVentasDao.findAllLikeJerarquia(filterAb7804s00,
				tableRequestDto);
		Long recordNum = this.tipoVentasDao.findAllLikeCountJerarquia(filterAb7804s00, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<TipoVenta>>(tableRequestDto, recordNum, listaAb7804s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>>
	 */
	public TableResponseDto<JerarquiaDto<TipoVenta>> jerarquiaChildren(TipoVenta filterAb7804s00,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<TipoVenta>> tableResponseDto = new TableResponseDto<JerarquiaDto<TipoVenta>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.tipoVentasDao.findAllChild(filterAb7804s00, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<TipoVenta> getMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.tipoVentasDao.getMultiple(filterAb7804s00, tableRequestDto, startsWith);
	}

}
