package com.ejie.ab78.service.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasService  
 * 
 *  
 */

public interface TipoVentasService {

	/**
	 * Inserts a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta add(TipoVenta tipoVenta);

	/**
	 * Updates a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta update(TipoVenta tipoVenta);

	/**
	 * Finds a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta find(TipoVenta tipoVenta);

	/**
	 * Deletes a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 */
	void remove(TipoVenta tipoVenta);

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	List<TipoVenta> findAll(TipoVenta tipoVenta, TableRequestDto tableRequestDto);

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	List<TipoVenta> findAllFilterProcedimiento(TipoVenta tipoVenta, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoVenta>
	 */
	List<TipoVenta> findAllLike(TipoVenta tipoVenta, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TipoVenta>
	 */
	TableResponseDto<TipoVenta> filter(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param searchAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	List<TableRowDto<TipoVenta>> search(TipoVenta filterAb7804s00, TipoVenta searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>>
	 */
	TableResponseDto<JerarquiaDto<TipoVenta>> jerarquia(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>>
	 */
	TableResponseDto<JerarquiaDto<TipoVenta>> jerarquiaChildren(TipoVenta filterAb7804s00,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<TipoVenta> getMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
