package com.ejie.ab78.service.maestros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.TipoReclamacionesDao;
import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoReclamacionesServiceImpl  
 * 
 *  
 */

@Service(value = "ab7805s00Service")
public class TipoReclamacionesServiceImpl implements TipoReclamacionesService {

	@Autowired
	private TipoReclamacionesDao tipoReclamacionesDao;

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion add(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionesDao.add(tipoReclamacion);
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion update(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionesDao.update(tipoReclamacion);
	}

	/**
	 * Finds a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion find(TipoReclamacion tipoReclamacion) {
		return (TipoReclamacion) this.tipoReclamacionesDao.find(tipoReclamacion);
	}

	/**
	 * Deletes a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoReclamacion tipoReclamacion) {
		this.tipoReclamacionesDao.remove(tipoReclamacion);
	}

	/**
	 * Finds a list of rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoReclamacion>
	 */
	public List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto) {
		return (List<TipoReclamacion>) this.tipoReclamacionesDao.findAll(tipoReclamacion, tableRequestDto);
	}

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoReclamacion>
	 */
	public List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return (List<TipoReclamacion>) this.tipoReclamacionesDao.findAllLike(tipoReclamacion, tableRequestDto,
				startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.tipoReclamacionesDao.removeMultiple(filterAb7805s00, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TipoReclamacion>
	 */
	public TableResponseDto<TipoReclamacion> filter(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<TipoReclamacion> listaAb7805s00 = this.tipoReclamacionesDao.findAllLike(filterAb7805s00, tableRequestDto,
				false);
		Long recordNum = this.tipoReclamacionesDao
				.findAllLikeCount(filterAb7805s00 != null ? filterAb7805s00 : new TipoReclamacion(), false);

		TableResponseDto<TipoReclamacion> usuarioDto = new TableResponseDto<TipoReclamacion>(tableRequestDto, recordNum,
				listaAb7805s00);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TipoReclamacion>> reorderSelection = this.tipoReclamacionesDao
					.reorderSelection(filterAb7805s00, tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<TipoReclamacion>> reorderSeeker = this.tipoReclamacionesDao
					.reorderSelection(filterAb7805s00, tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param searchAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	public List<TableRowDto<TipoReclamacion>> search(TipoReclamacion filterAb7805s00, TipoReclamacion searchAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.tipoReclamacionesDao.search(filterAb7805s00, searchAb7805s00, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.tipoReclamacionesDao.reorderSelection(filterAb7805s00, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>>
	 */
	public TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquia(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<TipoReclamacion>> listaAb7805s00 = this.tipoReclamacionesDao
				.findAllLikeJerarquia(filterAb7805s00, tableRequestDto);
		Long recordNum = this.tipoReclamacionesDao.findAllLikeCountJerarquia(filterAb7805s00, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<TipoReclamacion>>(tableRequestDto, recordNum, listaAb7805s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the TipoReclamacion
	 * table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>>
	 */
	public TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquiaChildren(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<TipoReclamacion>> tableResponseDto = new TableResponseDto<JerarquiaDto<TipoReclamacion>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.tipoReclamacionesDao.findAllChild(filterAb7805s00, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<TipoReclamacion> getMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.tipoReclamacionesDao.getMultiple(filterAb7805s00, tableRequestDto, startsWith);
	}

}
