package com.ejie.ab78.service.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoReclamacionesService  
 * 
 *  
 */

public interface TipoReclamacionesService {

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion add(TipoReclamacion tipoReclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion update(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion find(TipoReclamacion tipoReclamacion);

	/**
	 * Deletes a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 */
	void remove(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a list of rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoReclamacion>
	 */
	List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoReclamacion>
	 */
	List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<TipoReclamacion>
	 */
	TableResponseDto<TipoReclamacion> filter(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param searchAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	List<TableRowDto<TipoReclamacion>> search(TipoReclamacion filterAb7805s00, TipoReclamacion searchAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>>
	 */
	TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquia(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the TipoReclamacion
	 * table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>>
	 */
	TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquiaChildren(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<TipoReclamacion> getMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
