package com.ejie.ab78.service.maestros;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.dao.maestros.TipoEstablecimientoDao;
import com.ejie.ab78.model.maestros.TipoEstablecimiento;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * Ab6311s00ServiceImpl  
 * 
 *  
 */

@Service(value = "tipoEstablecimientoService")
public class TipoEstablecimientoServiceImpl implements TipoEstablecimientoService {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private TipoEstablecimientoDao tipoEstablecimientoDao;

	@Transactional(rollbackFor = Throwable.class)
	public TipoEstablecimiento add(TipoEstablecimiento ab6311s00) {
		return this.tipoEstablecimientoDao.add(ab6311s00);
	}

	@Transactional(rollbackFor = Throwable.class)
	public TipoEstablecimiento update(TipoEstablecimiento ab6311s00) {
		return this.tipoEstablecimientoDao.update(ab6311s00);
	}

	public TipoEstablecimiento find(TipoEstablecimiento ab6311s00) {
		return this.tipoEstablecimientoDao.find(ab6311s00);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoEstablecimiento ab6311s00) {
		this.tipoEstablecimientoDao.remove(ab6311s00);
	}

	public List<TipoEstablecimiento> findAll(TipoEstablecimiento ab6311s00, JQGridRequestDto jqGridRequestDto,
			String flagOtros) {

		List<TipoEstablecimiento> lista = this.tipoEstablecimientoDao.findAll(ab6311s00, jqGridRequestDto);

		if (StringUtils.isNotBlank(flagOtros)) {
			TipoEstablecimiento tipo = new TipoEstablecimiento();
			tipo.setIdTipoEstablecimiento("O");
			tipo.setDescripcionCastellano("Otros");
			tipo.setDescripcionEuskera("Beste batzuk");
			lista.add(tipo);
		}

		return lista;
	}

	public List<TipoEstablecimiento> findAllLike(TipoEstablecimiento ab6311s00, TableRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.tipoEstablecimientoDao.findAllLike(ab6311s00, jqGridRequestDto, startsWith);
	}

	public TableResponseDto<TipoEstablecimiento> filter(TipoEstablecimiento filterAb6311s00,
			TableRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TipoEstablecimiento> listaAb6311s00 = this.tipoEstablecimientoDao.findAllLike(filterAb6311s00, jqGridRequestDto,
				false);
		Long recordNum = this.tipoEstablecimientoDao
				.findAllLikeCount(filterAb6311s00 != null ? filterAb6311s00 : new TipoEstablecimiento(), false);

		for (TipoEstablecimiento tipoEstablecimiento : listaAb6311s00) {

			if (tipoEstablecimiento.getOrdenacion() != null) {

				if (Constantes.RECLAMACION.equals(tipoEstablecimiento.getOrdenacion().trim())) {

					tipoEstablecimiento.setDescOrdenacion(
							appMessageSource.getMessage("reclamaciones", null, LocaleContextHolder.getLocale()));

				} else if (Constantes.ORDENACION.equals(tipoEstablecimiento.getOrdenacion().trim())) {

					tipoEstablecimiento.setDescOrdenacion(
							appMessageSource.getMessage("ordenacion", null, LocaleContextHolder.getLocale()));

				}

			}

			if (tipoEstablecimiento.getTipificacion() != null) {

				if (Constantes.TIPIFICACION_ALOJAMIENTO.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(appMessageSource.getMessage("tipificacion.alojamiento",
							null, LocaleContextHolder.getLocale()));

				} else if (Constantes.TIPIFICACION_MEDIACION.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(appMessageSource.getMessage("tipificacion.mediacion", null,
							LocaleContextHolder.getLocale()));

				} else if (Constantes.TIPIFICACION_PROFESIONES_TURISTICAS
						.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(appMessageSource.getMessage("tipificacion.profesiones",
							null, LocaleContextHolder.getLocale()));

				} else if (Constantes.TIPIFICACION_OTRAS_ACAMPADAS
						.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(appMessageSource.getMessage("tipificacion.otrasAcampadas",
							null, LocaleContextHolder.getLocale()));

				} else if (Constantes.TIPIFICACION_INTERES_TURISTICO
						.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(
							appMessageSource.getMessage("tipificacion.interes", null, LocaleContextHolder.getLocale()));

				} else if (Constantes.TIPIFICACION_OTROS.equals(tipoEstablecimiento.getTipificacion().trim())) {

					tipoEstablecimiento.setDescTipificacion(
							appMessageSource.getMessage("tipificacion.otros", null, LocaleContextHolder.getLocale()));
				}
			}

		}

		return new TableResponseDto<TipoEstablecimiento>(jqGridRequestDto, recordNum, listaAb6311s00);
	}
}
