package com.ejie.ab78.service.maestros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.ProductosDao;
import com.ejie.ab78.model.maestros.Producto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProductosServiceImpl  
 * 
 *  
 */

@Service(value = "ab7803s00Service")
public class ProductosServiceImpl implements ProductosService {

	@Autowired
	private ProductosDao productosDao;

	/**
	 * Inserts a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Producto add(Producto producto) {
		return this.productosDao.add(producto);
	}

	/**
	 * Updates a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Producto update(Producto producto) {
		return this.productosDao.update(producto);
	}

	/**
	 * Finds a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto find(Producto producto) {
		return (Producto) this.productosDao.find(producto);
	}

	/**
	 * Deletes a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Producto producto) {
		this.productosDao.remove(producto);
	}

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	public List<Producto> findAll(Producto producto, TableRequestDto tableRequestDto) {
		return (List<Producto>) this.productosDao.findAll(producto, tableRequestDto);
	}

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	public List<Producto> findAllFilterProcedimiento(Producto producto, TableRequestDto tableRequestDto) {
		return (List<Producto>) this.productosDao.findAllFilterProcedimiento(producto, tableRequestDto);
	}

	/**
	 * Finds rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Producto>
	 */
	public List<Producto> findAllLike(Producto producto, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<Producto>) this.productosDao.findAllLike(producto, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.productosDao.removeMultiple(filterAb7803s00, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Producto>
	 */
	public TableResponseDto<Producto> filter(Producto filterAb7803s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Producto> listaAb7803s00 = this.productosDao.findAllLike(filterAb7803s00, tableRequestDto, false);
		Long recordNum = this.productosDao.findAllLikeCount(filterAb7803s00 != null ? filterAb7803s00 : new Producto(),
				false);

		TableResponseDto<Producto> usuarioDto = new TableResponseDto<Producto>(tableRequestDto, recordNum,
				listaAb7803s00);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Producto>> reorderSelection = this.productosDao.reorderSelection(filterAb7803s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<Producto>> reorderSeeker = this.productosDao.reorderSelection(filterAb7803s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param searchAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	public List<TableRowDto<Producto>> search(Producto filterAb7803s00, Producto searchAb7803s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.productosDao.search(filterAb7803s00, searchAb7803s00, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.productosDao.reorderSelection(filterAb7803s00, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Producto>>
	 */
	public TableResponseDto<JerarquiaDto<Producto>> jerarquia(Producto filterAb7803s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Producto>> listaAb7803s00 = this.productosDao.findAllLikeJerarquia(filterAb7803s00,
				tableRequestDto);
		Long recordNum = this.productosDao.findAllLikeCountJerarquia(filterAb7803s00, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<Producto>>(tableRequestDto, recordNum, listaAb7803s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Producto>>
	 */
	public TableResponseDto<JerarquiaDto<Producto>> jerarquiaChildren(Producto filterAb7803s00,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<Producto>> tableResponseDto = new TableResponseDto<JerarquiaDto<Producto>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.productosDao.findAllChild(filterAb7803s00, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Producto> getMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.productosDao.getMultiple(filterAb7803s00, tableRequestDto, startsWith);
	}

}
