package com.ejie.ab78.service.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Producto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProductosService  
 * 
 *  
 */

public interface ProductosService {

	/**
	 * Inserts a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Deletes a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 */
	void remove(Producto producto);

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	List<Producto> findAll(Producto producto, TableRequestDto tableRequestDto);

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	List<Producto> findAllFilterProcedimiento(Producto producto, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Producto>
	 */
	List<Producto> findAllLike(Producto producto, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Producto>
	 */
	TableResponseDto<Producto> filter(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param searchAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	List<TableRowDto<Producto>> search(Producto filterAb7803s00, Producto searchAb7803s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Producto>>
	 */
	TableResponseDto<JerarquiaDto<Producto>> jerarquia(Producto filterAb7803s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Producto>>
	 */
	TableResponseDto<JerarquiaDto<Producto>> jerarquiaChildren(Producto filterAb7803s00,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Producto> getMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
