package com.ejie.ab78.service.maestros;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.MotivosDao;
import com.ejie.ab78.model.maestros.Motivo;

/**
 * MotivosServiceImpl  
 * 
 *  
 */

@Service(value = "motivoService")
public class MotivosServiceImpl implements MotivosService {

	@Autowired
	private MotivosDao motivosDao;

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Motivo add(Motivo motivo) {
		return this.motivosDao.add(motivo);
	}

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Motivo update(Motivo motivo) {
		return this.motivosDao.update(motivo);
	}

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public Motivo find(Motivo motivo) {
		return (Motivo) this.motivosDao.find(motivo);
	}

	/**
	 * Deletes a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Motivo motivo) {
		this.motivosDao.remove(motivo);
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	public List<Motivo> findAll(Motivo motivo, TableRequestDto tableRequestDto) {
		return (List<Motivo>) this.motivosDao.findAll(motivo, tableRequestDto);
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	public List<Motivo> findAllFilterProcedimiento(Motivo motivo, TableRequestDto tableRequestDto) {
		return (List<Motivo>) this.motivosDao.findAllFilterProcedimiento(motivo, tableRequestDto);
	}

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	public List<Motivo> findAllLike(Motivo motivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<Motivo>) this.motivosDao.findAllLike(motivo, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.motivosDao.removeMultiple(filterMotivo, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelacionMotivoDen>
	 */
	public TableResponseDto<Motivo> filter(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		List<Motivo> listaMotivo = this.motivosDao.findAllLike(filterMotivo, tableRequestDto, false);
		Long recordNum = this.motivosDao.findAllLikeCount(filterMotivo != null ? filterMotivo : new Motivo(), false);

		TableResponseDto<Motivo> usuarioDto = new TableResponseDto<Motivo>(tableRequestDto, recordNum, listaMotivo);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Motivo>> reorderSelection = this.motivosDao.reorderSelection(filterMotivo, tableRequestDto,
					startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<Motivo>> reorderSeeker = this.motivosDao.reorderSelection(filterMotivo, tableRequestDto,
					startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param searchMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	public List<TableRowDto<Motivo>> search(Motivo filterMotivo, Motivo searchMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.motivosDao.search(filterMotivo, searchMotivo, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.motivosDao.reorderSelection(filterMotivo, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	public TableResponseDto<JerarquiaDto<Motivo>> jerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Motivo>> listaMotivo = this.motivosDao.findAllLikeJerarquia(filterMotivo, tableRequestDto);
		Long recordNum = this.motivosDao.findAllLikeCountJerarquia(filterMotivo, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<Motivo>>(tableRequestDto, recordNum, listaMotivo);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the RelacionMotivoDen
	 * table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	public TableResponseDto<JerarquiaDto<Motivo>> jerarquiaChildren(Motivo filterMotivo,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<Motivo>> tableResponseDto = new TableResponseDto<JerarquiaDto<Motivo>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.motivosDao.findAllChild(filterMotivo, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Motivo> getMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.motivosDao.getMultiple(filterMotivo, tableRequestDto, startsWith);
	}

}
