package com.ejie.ab78.service.maestros;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import com.ejie.ab78.model.maestros.Motivo;

/**
 * MotivosService  
 * 
 *  
 */

public interface MotivosService {

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo add(Motivo motivo);

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo update(Motivo motivo);

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo find(Motivo motivo);

	/**
	 * Deletes a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 */
	void remove(Motivo motivo);

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	List<Motivo> findAll(Motivo motivo, TableRequestDto tableRequestDto);

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	List<Motivo> findAllFilterProcedimiento(Motivo motivo, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	List<Motivo> findAllLike(Motivo motivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelacionMotivoDen>
	 */
	TableResponseDto<Motivo> filter(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param searchMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<Motivo>> search(Motivo filterMotivo, Motivo searchMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	TableResponseDto<JerarquiaDto<Motivo>> jerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the RelacionMotivoDen
	 * table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	TableResponseDto<JerarquiaDto<Motivo>> jerarquiaChildren(Motivo filterMotivo, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Motivo> getMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

}
