package com.ejie.ab78.service.maestros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.IrregularidadesDao;
import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * IrregularidadsServiceImpl  
 * 
 *  
 */

@Service(value = "irregularidadesService")
public class IrregularidadesServiceImpl implements IrregularidadesService {

	@Autowired
	private IrregularidadesDao irregularidadesDao;

	/**
	 * Inserts a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Irregularidad add(Irregularidad irregularidad) {
		return this.irregularidadesDao.add(irregularidad);
	}

	/**
	 * Updates a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Irregularidad update(Irregularidad irregularidad) {
		return this.irregularidadesDao.update(irregularidad);
	}

	/**
	 * Finds a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	public Irregularidad find(Irregularidad irregularidad) {
		return (Irregularidad) this.irregularidadesDao.find(irregularidad);
	}

	/**
	 * Deletes a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Irregularidad irregularidad) {
		this.irregularidadesDao.remove(irregularidad);
	}

	/**
	 * Finds a list of rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Irregularidad>
	 */
	public List<Irregularidad> findAll(Irregularidad irregularidad, TableRequestDto tableRequestDto) {
		return (List<Irregularidad>) this.irregularidadesDao.findAll(irregularidad, tableRequestDto);
	}

	/**
	 * Finds rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Irregularidad>
	 */
	public List<Irregularidad> findAllLike(Irregularidad irregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return (List<Irregularidad>) this.irregularidadesDao.findAllLike(irregularidad, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.irregularidadesDao.removeMultiple(filterIrregularidad, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Irregularidad>
	 */
	public TableResponseDto<Irregularidad> filter(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Irregularidad> listaAb7804s00 = this.irregularidadesDao.findAllLike(filterIrregularidad, tableRequestDto,
				false);
		Long recordNum = this.irregularidadesDao
				.findAllLikeCount(filterIrregularidad != null ? filterIrregularidad : new Irregularidad(), false);

		TableResponseDto<Irregularidad> usuarioDto = new TableResponseDto<Irregularidad>(tableRequestDto, recordNum,
				listaAb7804s00);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Irregularidad>> reorderSelection = this.irregularidadesDao
					.reorderSelection(filterIrregularidad, tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<Irregularidad>> reorderSeeker = this.irregularidadesDao
					.reorderSelection(filterIrregularidad, tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param searchAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	public List<TableRowDto<Irregularidad>> search(Irregularidad filterIrregularidad, Irregularidad searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.irregularidadesDao.search(filterIrregularidad, searchAb7804s00, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.irregularidadesDao.reorderSelection(filterIrregularidad, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Irregularidad>>
	 */
	public TableResponseDto<JerarquiaDto<Irregularidad>> jerarquia(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Irregularidad>> listaAb7804s00 = this.irregularidadesDao
				.findAllLikeJerarquia(filterIrregularidad, tableRequestDto);
		Long recordNum = this.irregularidadesDao.findAllLikeCountJerarquia(filterIrregularidad, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<Irregularidad>>(tableRequestDto, recordNum, listaAb7804s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Irregularidad
	 * table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Irregularidad>>
	 */
	public TableResponseDto<JerarquiaDto<Irregularidad>> jerarquiaChildren(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<Irregularidad>> tableResponseDto = new TableResponseDto<JerarquiaDto<Irregularidad>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.irregularidadesDao.findAllChild(filterIrregularidad, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Irregularidad> getMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.irregularidadesDao.getMultiple(filterIrregularidad, tableRequestDto, startsWith);
	}

}
