package com.ejie.ab78.service.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * IrregularidadsService  
 * 
 *  
 */

public interface IrregularidadesService {

	/**
	 * Inserts a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad add(Irregularidad irregularidad);

	/**
	 * Updates a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad update(Irregularidad irregularidad);

	/**
	 * Finds a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad find(Irregularidad irregularidad);

	/**
	 * Deletes a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 */
	void remove(Irregularidad irregularidad);

	/**
	 * Finds a list of rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Irregularidad>
	 */
	List<Irregularidad> findAll(Irregularidad irregularidad, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Irregularidad>
	 */
	List<Irregularidad> findAllLike(Irregularidad irregularidad, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Irregularidad>
	 */
	TableResponseDto<Irregularidad> filter(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param searchAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	List<TableRowDto<Irregularidad>> search(Irregularidad filterIrregularidad, Irregularidad searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Irregularidad>>
	 */
	TableResponseDto<JerarquiaDto<Irregularidad>> jerarquia(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Irregularidad
	 * table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Irregularidad>>
	 */
	TableResponseDto<JerarquiaDto<Irregularidad>> jerarquiaChildren(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Irregularidad> getMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
