package com.ejie.ab78.service.maestros;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.dao.maestros.DecisionesDao;
import com.ejie.ab78.model.maestros.Decision;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DecisionesServiceImpl  
 * 
 *  
 */

@Service(value = "ab7802s00Service")
public class DecisionesServiceImpl implements DecisionesService {

	@Autowired
	private DecisionesDao decisionesDao;

	/**
	 * Inserts a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision add(Decision decision) {
		return this.decisionesDao.add(decision);
	}

	/**
	 * Updates a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision update(Decision decision) {
		return this.decisionesDao.update(decision);
	}

	/**
	 * Finds a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	public Decision find(Decision decision) {
		return (Decision) this.decisionesDao.find(decision);
	}

	/**
	 * Deletes a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Decision decision) {
		this.decisionesDao.remove(decision);
	}

	/**
	 * Finds a list of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Decision>
	 */
	public List<Decision> findAll(Decision decision, TableRequestDto tableRequestDto) {
		return (List<Decision>) this.decisionesDao.findAll(decision, tableRequestDto);
	}

	public List<Decision> findAllFilterProcedimiento(Decision decision, TableRequestDto tableRequestDto) {
		return (List<Decision>) this.decisionesDao.findAllFilterProcedimiento(decision, tableRequestDto);
	}

	/**
	 * Finds rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Decision>
	 */
	public List<Decision> findAllLike(Decision decision, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<Decision>) this.decisionesDao.findAllLike(decision, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.decisionesDao.removeMultiple(filterAb7802s00, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Decision>
	 */
	public TableResponseDto<Decision> filter(Decision filterAb7802s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Decision> listaAb7802s00 = this.decisionesDao.findAllLike(filterAb7802s00, tableRequestDto, false);
		Long recordNum = this.decisionesDao.findAllLikeCount(filterAb7802s00 != null ? filterAb7802s00 : new Decision(),
				false);

		TableResponseDto<Decision> usuarioDto = new TableResponseDto<Decision>(tableRequestDto, recordNum,
				listaAb7802s00);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Decision>> reorderSelection = this.decisionesDao.reorderSelection(filterAb7802s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<Decision>> reorderSeeker = this.decisionesDao.reorderSelection(filterAb7802s00,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param searchAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	public List<TableRowDto<Decision>> search(Decision filterAb7802s00, Decision searchAb7802s00,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.decisionesDao.search(filterAb7802s00, searchAb7802s00, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.decisionesDao.reorderSelection(filterAb7802s00, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Decision>>
	 */
	public TableResponseDto<JerarquiaDto<Decision>> jerarquia(Decision filterAb7802s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Decision>> listaAb7802s00 = this.decisionesDao.findAllLikeJerarquia(filterAb7802s00,
				tableRequestDto);
		Long recordNum = this.decisionesDao.findAllLikeCountJerarquia(filterAb7802s00, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<Decision>>(tableRequestDto, recordNum, listaAb7802s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Decision>>
	 */
	public TableResponseDto<JerarquiaDto<Decision>> jerarquiaChildren(Decision filterAb7802s00,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<Decision>> tableResponseDto = new TableResponseDto<JerarquiaDto<Decision>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.decisionesDao.findAllChild(filterAb7802s00, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Decision> getMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.decisionesDao.getMultiple(filterAb7802s00, tableRequestDto, startsWith);
	}

}
