package com.ejie.ab78.service.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Decision;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DecisionesService  
 * 
 *  
 */

public interface DecisionesService {

	/**
	 * Inserts a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision add(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision update(Decision decision);

	/**
	 * Finds a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision find(Decision decision);

	/**
	 * Deletes a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 */
	void remove(Decision decision);

	/**
	 * Finds a list of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Decision>
	 */
	List<Decision> findAll(Decision decision, TableRequestDto tableRequestDto);

	/**
	 * Finds a list of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Decision>
	 */
	List<Decision> findAllFilterProcedimiento(Decision decision, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Decision>
	 */
	List<Decision> findAllLike(Decision decision, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Decision>
	 */
	TableResponseDto<Decision> filter(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param searchAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	List<TableRowDto<Decision>> search(Decision filterAb7802s00, Decision searchAb7802s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Decision>>
	 */
	TableResponseDto<JerarquiaDto<Decision>> jerarquia(Decision filterAb7802s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Decision>>
	 */
	TableResponseDto<JerarquiaDto<Decision>> jerarquiaChildren(Decision filterAb7802s00,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Decision> getMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
