package com.ejie.ab78.service.listados;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.adaptadores.ab61WebServiceAdaptadorService;
import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab78.clientesWS.ab61WebService.ParametrosWS;
import com.ejie.ab78.dao.listados.ListadosDao;
import com.ejie.ab78.model.listados.Listados;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ListadosServiceImpl  
 * 
 *  
 */

@Service(value = "listadosService")
public class ListadosServiceImpl implements ListadosService {

	@Autowired
	private ListadosDao listadosDao;

	@Autowired
	private ab61WebServiceAdaptadorService ab61WebServiceAdaptadorService;

	/**
	 * Finds a single row in the Listados table.
	 *
	 * @param listados
	 *            Listados
	 * @return Listados
	 */
	public Listados find(Listados listados) {
		return (Listados) this.listadosDao.find(listados);
	}

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param listados
	 *            Listados
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Listados>
	 */
	public List<Listados> findAllLike(Listados listados, TableRequestDto TableRequestDto, Boolean startsWith) {
		return (List<Listados>) this.listadosDao.findAllLike(listados, TableRequestDto, startsWith);
	}

	/**
	 * llama al webService que genera un XLS con las busquedas seleccionadas
	 * 
	 * @param listados
	 * @return string ruta fichero pif
	 * @throws Exception
	 */
	public String gerenarXLS(Listados listados) throws Ab61Exception {
		List<BusquedasWS> listaBusquedas = new ArrayList<BusquedasWS>();
		if (null != listados && "" != listados.getResultado()) {
			// Separamos las diferentes busquedas
			String[] resultadoArray = listados.getResultado().split("&");
			// por cada busqueda separamos id y lista de parametros
			for (int i = 0; i < resultadoArray.length; i++) {
				String[] busquedaParametros = resultadoArray[i].split("#");
				if (busquedaParametros.length >= 1) {
					BusquedasWS busqueda = new BusquedasWS();
					busqueda.setIdBusqueda(Integer.parseInt(busquedaParametros[0]));
					if (busquedaParametros.length > 1) {
						String listaParametros = busquedaParametros[1];
						String[] listaParametrosArray = listaParametros.split(",");
						for (int j = 0; j < listaParametrosArray.length; j++) {
							String[] idValParametro = listaParametrosArray[j].split("@");
							if (idValParametro.length > 1) {
								ParametrosWS parametro = new ParametrosWS();
								parametro.setIdParametro(Integer.parseInt(idValParametro[0]));
								parametro.setValor(idValParametro[1]);
								busqueda.getParametros().add(parametro);
							}
						}
					}
					listaBusquedas.add(busqueda);
				}
			}
		}

		return ab61WebServiceAdaptadorService.generarExcelListados(listados.getIdListado(), listaBusquedas, "ab78");
	}

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param idProcedimiento
	 *            Integer
	 * @return List<Listados>
	 */
	public List<Listados> findRelLisProByProc(Integer idProcedimiento) {
		return this.listadosDao.findRelLisProByProc(idProcedimiento);
	}
}
