package com.ejie.ab78.service.listados;

import java.util.List;

import com.ejie.ab78.model.listados.Listados;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ListadosService  
 * 
 *  
 */

public interface ListadosService {

	/**
	 * Finds a single row in the Listados table.
	 *
	 * @param listados
	 *            Listados
	 * @return Listados
	 */
	Listados find(Listados listados);

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param listados
	 *            Listados
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Listados>
	 */
	List<Listados> findAllLike(Listados listados, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * llama al webService que genera un XLS con las busquedas seleccionadas
	 * 
	 * @param listados
	 * @return string ruta fichero pif
	 * @throws Exception
	 */
	String gerenarXLS(Listados listados) throws Exception;

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param idProcedimiento
	 *            Integer
	 * @return List<Listados>
	 */
	List<Listados> findRelLisProByProc(Integer idProcedimiento);
}
